﻿---
title: max_size
description: The maximum approximate size an index is allowed to be before triggering a rollover.  Sizes must use Elasticsearch-approved human-readable byte units...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_size
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# max_size
```yaml
action: rollover
description: >-
  Rollover the index associated with alias 'aliasname', which should be in the
  form of prefix-000001 (or similar), or prefix-yyyy.MM.DD-1.
options:
  name: aliasname
  conditions:
    max_size: 5gb
```

<note>
  At least one of [max_age](https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_age), [max_docs](https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_docs), max_size or any combinations of the three are required as `conditions:` for the [Rollover](https://www.elastic.co/docs/reference/elasticsearch/curator/rollover) action.
</note>

The maximum approximate size an index is allowed to be before triggering a rollover.  Sizes must use Elasticsearch-approved [human-readable byte units](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/common-options). It *must* be nested under `conditions:` There is no default value.  If this condition is specified, it must have a value, or Curator will generate an error.