﻿---
title: max_docs
description: The maximum number of documents allowed in an index before triggering a rollover.  It must be nested under conditions: There is no default value. If this...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_docs
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# max_docs
```yaml
action: rollover
description: >-
  Rollover the index associated with alias 'aliasname', which should be in the
  form of prefix-000001 (or similar), or prefix-yyyy.MM.DD-1.
options:
  name: aliasname
  conditions:
    max_docs: 1000000
```

<note>
  At least one of [max_age](https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_age), max_docs, [max_size](https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_size) or any combinations of the three are required as `conditions:` for the [Rollover](https://www.elastic.co/docs/reference/elasticsearch/curator/rollover) action.
</note>

The maximum number of documents allowed in an index before triggering a rollover.  It *must* be nested under `conditions:` There is no default value. If this condition is specified, it must have a value, or Curator will generate an error.