﻿---
title: include_global_state
description: This setting must be either True or False. The value of this setting determines whether Elasticsearch should include the global cluster state with the...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/option_include_gs
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# include_global_state
<note>
  This setting is used by the [snapshot](https://www.elastic.co/docs/reference/elasticsearch/curator/snapshot) and [restore](https://www.elastic.co/docs/reference/elasticsearch/curator/restore) actions.
</note>

This setting must be either `True` or `False`.
The value of this setting determines whether Elasticsearch should include the global cluster state with the snapshot or restore.
When performing a [snapshot](https://www.elastic.co/docs/reference/elasticsearch/curator/snapshot), the default value of this setting is `True`.
When performing a [restore](https://www.elastic.co/docs/reference/elasticsearch/curator/restore), the default value of this setting is `False`.

## [restore](https://www.elastic.co/docs/reference/elasticsearch/curator/restore)

```yaml
actions:
  1:
    action: restore
    description: Restore my_index from my_snapshot in my_repository
    options:
      repository: my_repository
      name: my_snapshot
      indices: my_index
      include_global_state: False
      wait_for_completion: True
      max_wait: 3600
      wait_interval: 10
    filters:
    - filtertype: state
      state: SUCCESS
      exclude:
    - filtertype: ...
```


## [snapshot](https://www.elastic.co/docs/reference/elasticsearch/curator/snapshot)

```yaml
action: snapshot
description: >-
  Snapshot selected indices to 'repository' with the snapshot name or name
  pattern in 'name'.  Use all other options as assigned
options:
  repository: my_repository
  name: my_snapshot
  include_global_state: True
  wait_for_completion: True
  max_wait: 3600
  wait_interval: 10
filters:
- filtertype: ...
```