﻿---
title: ignore_unavailable
description: This setting must be either True or False. The default value of this setting is False When the ignore_unavailable option is False and an index is missing...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/option_ignore
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# ignore_unavailable
<note>
  This setting is used by the [snapshot](https://www.elastic.co/docs/reference/elasticsearch/curator/snapshot), [restore](https://www.elastic.co/docs/reference/elasticsearch/curator/restore), and [index_settings](https://www.elastic.co/docs/reference/elasticsearch/curator/index_settings) actions.
</note>

This setting must be either `True` or `False`.
The default value of this setting is `False`

## [restore](https://www.elastic.co/docs/reference/elasticsearch/curator/restore)

```yaml
actions:
  1:
    action: restore
    description: Restore my_index from my_snapshot in my_repository
    options:
      repository: my_repository
      name: my_snapshot
      indices: my_index
      ignore_unavailable: True
      wait_for_completion: True
      max_wait: 3600
      wait_interval: 10
    filters:
    - filtertype: state
      state: SUCCESS
      exclude:
    - filtertype: ...
```

When the `ignore_unavailable` option is `False` and an index is missing the restore request will fail.

## [snapshot](https://www.elastic.co/docs/reference/elasticsearch/curator/snapshot)

```yaml
action: snapshot
description: >-
  Snapshot selected indices to 'repository' with the snapshot name or name
  pattern in 'name'.  Use all other options as assigned
options:
  repository: my_repository
  name: my_snapshot
  ignore_unavailable: False
  wait_for_completion: True
  max_wait: 3600
  wait_interval: 10
filters:
- filtertype: ...
```

When the `ignore_unavailable` option is `False` and an index is missing, the snapshot request will fail.  This is not frequently a concern in Curator, as it should only ever find indices that exist.

## [index_settings](https://www.elastic.co/docs/reference/elasticsearch/curator/index_settings)

```yaml
action: index_settings
description: "Change settings for selected indices"
options:
  index_settings:
    index:
      refresh_interval: 5s
  ignore_unavailable: False
  preserve_existing: False
filters:
- filtertype: ...
```

When the `ignore_unavailable` option is `False` and an index is missing, or if the request is to apply a [static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-dynamic) setting and the index is opened, the index setting request will fail. The `ignore_unavailable` option allows these indices to be skipped, when set to `True`.
<note>
  [Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#static-dynamic) index settings can be applied to either open or closed indices.
</note>