﻿---
title: Open action
description: This action opens the selected indices. search_pattern, ignore_empty_list, timeout_override, continue_if_exception, disable_action. 
url: https://www.elastic.co/docs/reference/elasticsearch/curator/open
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# Open action
```yaml
action: open
description: "open selected indices"
options:
  continue_if_exception: False
filters:
- filtertype: ...
```

<note>
  Empty values and commented lines will result in the default value, if any, being selected.  If a setting is set, but not used by a given action, it will be ignored.
</note>

This action opens the selected indices.

## Optional settings

- [search_pattern](https://www.elastic.co/docs/reference/elasticsearch/curator/option_search_pattern)
- [ignore_empty_list](https://www.elastic.co/docs/reference/elasticsearch/curator/option_ignore_empty)
- [timeout_override](https://www.elastic.co/docs/reference/elasticsearch/curator/option_timeout_override)
- [continue_if_exception](https://www.elastic.co/docs/reference/elasticsearch/curator/option_continue)
- [disable_action](https://www.elastic.co/docs/reference/elasticsearch/curator/option_disable)

<tip>
  See an example of this action in an [actionfile](https://www.elastic.co/docs/reference/elasticsearch/curator/actionfile) [here](https://www.elastic.co/docs/reference/elasticsearch/curator/ex_open).
</tip>