﻿---
title: Index Settings
description: This action updates the specified index settings for the selected indices. search_pattern, ignore_empty_list, timeout_override, continue_if_exception,...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/index_settings
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# Index Settings
```yaml
action: index_settings
description: "Change settings for selected indices"
options:
  index_settings:
    index:
      refresh_interval: 5s
  ignore_unavailable: False
  preserve_existing: False
filters:
- filtertype: ...
```

<note>
  Empty values and commented lines will result in the default value, if any, being selected.  If a setting is set, but not used by a given action, it will be ignored.
</note>

This action updates the specified index settings for the selected indices.
<important>
  While Elasticsearch allows for either dotted notation of index settings, such as
  ```json
  PUT /indexname/_settings
  {
    "index.blocks.read_only": true
  }
  ```
  or in nested structure, like this:
  ```json
  PUT /indexname/_settings
  {
    "index": {
      "blocks": {
        "read_only": true
      }
    }
  }
  ```
  In order to appropriately detect static vs. dynamic [index settings](https://www.elastic.co/docs/reference/elasticsearch/index-settings) and to be able to verify configurational integrity in the YAML file, **Curator does not support using dotted notation.**
</important>


## Optional settings

- [search_pattern](https://www.elastic.co/docs/reference/elasticsearch/curator/option_search_pattern)
- [ignore_empty_list](https://www.elastic.co/docs/reference/elasticsearch/curator/option_ignore_empty)
- [timeout_override](https://www.elastic.co/docs/reference/elasticsearch/curator/option_timeout_override)
- [continue_if_exception](https://www.elastic.co/docs/reference/elasticsearch/curator/option_continue)
- [disable_action](https://www.elastic.co/docs/reference/elasticsearch/curator/option_disable)
- [ignore_unavailable](https://www.elastic.co/docs/reference/elasticsearch/curator/option_ignore)
- [preserve_existing](https://www.elastic.co/docs/reference/elasticsearch/curator/option_preserve_existing)

<tip>
  See an example of this action in an [actionfile](https://www.elastic.co/docs/reference/elasticsearch/curator/actionfile) [here](https://www.elastic.co/docs/reference/elasticsearch/curator/ex_index_settings).
</tip>