﻿---
title: ILM or Curator?
description: If ILM provides the functionality to manage your index lifecycle, and you have at least a Basic license, consider using ILM in place of Curator. Many...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/ilm-or-curator
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# ILM or Curator?
If ILM provides the functionality to manage your index lifecycle, and you have at least a Basic license, consider using ILM in place of Curator. Many of the Stack components make use of ILM by default.

## Beats

<note>
  All Beats share a similar ILM configuration. Filebeats is used as a reference here.
</note>

Starting with version 7.0, Filebeat uses index lifecycle management by default when it connects to a cluster that supports lifecycle management. Filebeat loads the default policy automatically and applies it to any indices created by Filebeat.
You can view and edit the policy in the Index lifecycle policies UI in Kibana. For more information about working with the UI, see [Configure a lifecycle policy](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/configure-lifecycle-policy).
Read more about Filebeat and ILM in [Configure index lifecycle management for Filebeat](https://www.elastic.co/docs/reference/beats/filebeat/ilm).

## Logstash

<note>
  The Index Lifecycle Management feature requires version 9.3.1 or higher of the `logstash-output-elasticsearch` plugin.
</note>

Logstash can use [index lifecycle management](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management) to automate the management of indices over time.
The use of Index Lifecycle Management is controlled by the `ilm_enabled` setting. By default, this will automatically detect whether the Elasticsearch instance supports ILM, and will use it if it is available. `ilm_enabled` can also be set to `true` or `false` to override the automatic detection, or disable ILM.
Read more about Logstash and ILM in the [Elasticsearch output plugin](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch#plugins-outputs-elasticsearch-ilm) docs.