﻿---
title: Forcemerge action in Elastic Curator
description: This action performs a forceMerge on the selected indices, merging them to max_num_segments per shard. You can optionally pause between each merge for...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/forcemerge
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# Forcemerge action in Elastic Curator
```yaml
action: forcemerge
description: >-
  Perform a forceMerge on selected indices to 'max_num_segments' per shard
options:
  max_num_segments: 2
  timeout_override: 21600
filters:
- filtertype: ...
```

<note>
  Empty values and commented lines will result in the default value, if any, being selected.  If a setting is set, but not used by a given action, it will be ignored.
</note>

This action performs a forceMerge on the selected indices, merging them to [max_num_segments](https://www.elastic.co/docs/reference/elasticsearch/curator/option_mns) per shard.
<warning>
  A [`forcemerge`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-forcemerge) should never be executed on an index that is actively receiving data.  It should only ever be performed on indices where no more documents are ever anticipated to be added in the future.
</warning>

You can optionally pause between each merge for [delay](https://www.elastic.co/docs/reference/elasticsearch/curator/option_delay) seconds to allow the cluster to quiesce:
```yaml
action: forcemerge
description: >-
  Perform a forceMerge on selected indices to 'max_num_segments' per shard
options:
  max_num_segments: 2
  timeout_override: 21600
  delay: 120
filters:
- filtertype: ...
```


## Required settings

- [max_num_segments](https://www.elastic.co/docs/reference/elasticsearch/curator/option_mns)


## Optional settings

- [search_pattern](https://www.elastic.co/docs/reference/elasticsearch/curator/option_search_pattern)
- [delay](https://www.elastic.co/docs/reference/elasticsearch/curator/option_delay)
- [ignore_empty_list](https://www.elastic.co/docs/reference/elasticsearch/curator/option_ignore_empty)
- [timeout_override](https://www.elastic.co/docs/reference/elasticsearch/curator/option_timeout_override)
- [continue_if_exception](https://www.elastic.co/docs/reference/elasticsearch/curator/option_continue)
- [disable_action](https://www.elastic.co/docs/reference/elasticsearch/curator/option_disable)

<tip>
  See an example of this action in an [actionfile](https://www.elastic.co/docs/reference/elasticsearch/curator/actionfile) [here](https://www.elastic.co/docs/reference/elasticsearch/curator/ex_forcemerge).
</tip>