﻿---
title: forcemerged
description: This filtertype will iterate over the actionable list and match indices which have max_num_segments segments per shard, or fewer.  They will remain in,...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_forcemerged
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# forcemerged
```yaml
- filtertype: forcemerged
  max_num_segments: 2
  exclude: True
```

<note>
  Empty values and commented lines will result in the default value, if any, being selected.  If a setting is set, but not used by a given [filtertype](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype), it may generate an error.
</note>

This [filtertype](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype) will iterate over the actionable list and match indices which have `max_num_segments` segments per shard, or fewer.  They will remain in, or be removed from the actionable list based on the value of [exclude](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_exclude).

## Required settings

- [max_num_segments](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_max_num_segments)


## Optional settings

- [exclude](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_exclude) (default is `True`)