﻿---
title: Elasticsearch Curator count filtertype for sorting
description: This filtertype will iterate over the actionable list of indices or snapshots. They are ordered by age, or by alphabet, so as to guarantee that the correct...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_count
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# Elasticsearch Curator count filtertype for sorting
```yaml
- filtertype: count
  count: 10
```

<note>
  Empty values and commented lines will result in the default value, if any, being selected.  If a setting is set, but not used by a given [filtertype](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype), it may generate an error.
</note>

This [filtertype](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype) will iterate over the actionable list of indices *or* snapshots. They are ordered by age, or by alphabet, so as to guarantee that the correct items will remain in, or be removed from the actionable list based on the values of [count](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_count), [exclude](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_exclude), and [reverse](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_reverse).

## Age-based sorting

For use cases where "like" items are being counted, and their name pattern guarantees date sorting is equal to alphabetical sorting, it is unnecessary to set [use_age](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_use_age) to `True`, as item names will be sorted in [reverse](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_reverse) order by default.  This means that the item count will start beginning with the *newest* indices or snapshots, and proceed through to the oldest.
Where this is not the case, the [`use_age`](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_use_age) setting can be used to ensure that index or snapshot ages are properly considered for sorting:
```yaml
- filtertype: count
  count: 10
  use_age: True
  source: creation_date
```

All of the age-related settings from the [`age`](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_age) filter are supported, and the same restrictions apply with regard to filtering indices vs. snapshots.

## Pattern-based sorting

```yaml
- filtertype: count
  count: 1
  pattern: '^(.*)-\d{6}$'
  reverse: true
```

This particular example will match indices following the basic rollover pattern of `indexname-######`, and keep the highest numbered index for each group.
For example, given indices `a-000001`, `a-000002`, `a-000003` and `b-000006`, and `b-000007`, the indices will would be matched are `a-000003` and `b-000007`. Indices that do not match the regular expression in `pattern` will be automatically excluded.
This is particularly useful with indices created and managed using the [Rollover API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-rollover), as you can select only the active indices with the above example ([`exclude`](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_exclude) defaults to `False`). Setting [`exclude`](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_exclude) to `True` with the above example will *remove* the active rollover indices, leaving only those which have been rolled-over.
While this is perhaps most useful for the aforementioned scenario, it can also be used with age-based indices as well.

## Reversing sorting

Using the default configuration, [`reverse`](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_reverse) is `True`.  Given These indices:
```sh
index1
index2
index3
index4
index5
```

And this filter:
```yaml
- filtertype: count
  count: 2
```

Indices `index5` and `index4` will be recognized as the `2` *most recent,* and will be removed from the actionable list, leaving `index1`, `index2`, and `index3` to be acted on by the given [action](https://www.elastic.co/docs/reference/elasticsearch/curator/actions).
Similarly, given these indices:
```sh
index-2017.03.01
index-2017.03.02
index-2017.03.03
index-2017.03.04
index-2017.03.05
```

And this filter:
```yaml
- filtertype: count
  count: 2
  use_age: True
  source: name
  timestring: '%Y.%m.%d'
```

The result will be similar.  Indices `index-2017.03.05` and `index-2017.03.04` will be recognized as the `2` *most recent,* and will be removed from the actionable list, leaving `index-2017.03.01`, `index-2017.03.02`, and `index-2017.03.03` to be acted on by the given [action](https://www.elastic.co/docs/reference/elasticsearch/curator/actions).
In some cases, you may wish to filter for the most recent indices.  To accomplish this you set [`reverse`](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_reverse) to `False`:
```yaml
- filtertype: count
  count: 2
  reverse: False
```

This time indices `index1` and `index2` will be the `2` which will be removed from the actionable list, leaving `index3`, `index4`, and `index5` to be acted on by the given [action](https://www.elastic.co/docs/reference/elasticsearch/curator/actions).
Likewise with the age sorted indices:
```yaml
- filtertype: count
  count: 2
  use_age: True
  source: name
  timestring: '%Y.%m.%d'
  reverse: True
```

Indices `index-2017.03.01` and `index-2017.03.02` will be the `2` which will be removed from the actionable list, leaving `index-2017.03.03`, `index-2017.03.04`, and `index-2017.03.05` to be acted on by the given [action](https://www.elastic.co/docs/reference/elasticsearch/curator/actions).

## Required settings

- [count](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_count)


## Optional settings

- [reverse](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_reverse)
- [use_age](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_use_age)
- [pattern](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_pattern)
- [source](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_source) (required if `use_age` is `True`)
- [timestring](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_timestring) (required if `source` is `name`)
- [exclude](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_exclude) (default is `True`)


## Index-only settings

- [field](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_field) (required if `source` is `field_stats`)
- [stats_result](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_stats_result) (only used if `source` is `field_stats`)