﻿---
title: allocated
description: This filtertype will iterate over the actionable list and match indices based on their shard routing allocation settings.  They will remain in, or be...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_allocated
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# allocated
```yaml
- filtertype: allocated
  key: ...
  value: ...
  allocation_type:
  exclude: True
```

<note>
  Empty values and commented lines will result in the default value, if any, being selected.  If a setting is set, but not used by a given [filtertype](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype), it may generate an error.
</note>

This [filtertype](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype) will iterate over the actionable list and match indices based on their shard routing allocation settings.  They will remain in, or be removed from the actionable list based on the value of [exclude](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_exclude).
By default the indices matched by the `allocated` filter will be excluded since the `exclude` setting defaults to `True`.
To include matching indices rather than exclude, set the `exclude` setting to `False`.

## Required settings

- [key](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_key)
- [value](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_value)


## Optional settings

- [allocation_type](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_allocation_type)
- [exclude](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_exclude) (default is `True`)