﻿---
title: Using the alias filter in Elasticsearch Curator
description: This filtertype will iterate over the actionable list and match indices based on whether they are associated with the given aliases, which can be a single...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_alias
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# Using the alias filter in Elasticsearch Curator
```yaml
- filtertype: alias
  aliases: ...
```

<note>
  Empty values and commented lines will result in the default value, if any, being selected.  If a setting is set, but not used by a given [filtertype](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype), it may generate an error.
</note>

This [filtertype](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype) will iterate over the actionable list and match indices based on whether they are associated with the given [aliases](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_aliases), which can be a single value, or an array.  They will remain in, or be removed from the actionable list based on the value of [exclude](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_exclude).
<admonition title="Matching indices and aliases">
  [Indices must be in all aliases to match](https://www.elastic.co/guide/en/elasticsearch/reference/5.5/breaking-changes-5.5.html#breaking_55_rest_changes).If a list of [aliases](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_aliases) is provided (instead of only one), indices must appear in *all* listed [aliases](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_aliases) or a 404 error will result, leading to no indices being matched. In older versions, if the index was associated with even one of the aliases in [aliases](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_aliases), it would result in a match.
</admonition>


## Required settings

- [aliases](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_aliases)


## Optional settings

- [exclude](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_exclude)