﻿---
title: filtertype
description: Each filter is defined first by a filtertype.  Each filtertype has its own settings, or no settings at all.  In a configuration file, filters are defined...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# filtertype
Each filter is defined first by a `filtertype`.  Each filtertype has its own settings, or no settings at all.  In a configuration file, filters are defined as follows:
```yaml
- filtertype: *first*
  setting1: ...
  ...
  settingN: ...
- filtertype: *second*
  setting1: ...
  ...
  settingN: ...
- filtertype: *third*
```

The `-` indicates in the YAML that this is an array element.  Each filtertype declaration must be preceded by a `-` for the filters to be read properly.  This is how Curator can chain filters together.  Anywhere filters can be used, multiple can be chained together in this manner.
The index filtertypes are:
- [age](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_age)
- [alias](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_alias)
- [allocated](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_allocated)
- [closed](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_closed)
- [count](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_count)
- [empty](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_empty)
- [forcemerged](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_forcemerged)
- [kibana](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_kibana)
- [none](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_none)
- [opened](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_opened)
- [pattern](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_pattern)
- [period](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_period)
- [space](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_space)

The snapshot filtertypes are:
- [age](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_age)
- [count](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_count)
- [none](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_none)
- [pattern](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_pattern)
- [period](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_period)
- [state](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_state)