﻿---
title: Filters
description: Filters are the way to select only the indices (or snapshots) you want. The index filtertypes are: age, alias, allocated, closed, count, empty, forcemerged,...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/filters
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# Filters
Filters are the way to select only the indices (or snapshots) you want.
<admonition title="Filter chaining">
  It is important to note that while filters can be chained, each is linked by an implied logical **AND** operation.  If you want to match from one of several different patterns, as with a logical **OR** operation, you can do so with the [pattern](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_pattern) filtertype using *regex* as the [kind](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_kind).This example shows how to select multiple indices based on them beginning with either `alpha-`, `bravo-`, or `charlie-`:
  ```yaml
    filters:
    - filtertype: pattern
      kind: regex
      value: '^(alpha-|bravo-|charlie-).*$'
  ```
  Explaining all of the different ways in which regular expressions can be used is outside the scope of this document, but hopefully this gives you some idea of how a regular expression pattern can be used when a logical **OR** is desired.
</admonition>

The index filtertypes are:
- [age](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_age)
- [alias](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_alias)
- [allocated](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_allocated)
- [closed](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_closed)
- [count](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_count)
- [empty](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_empty)
- [forcemerged](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_forcemerged)
- [kibana](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_kibana)
- [none](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_none)
- [opened](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_opened)
- [pattern](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_pattern)
- [period](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_period)
- [space](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_space)

The snapshot filtertypes are:
- [age](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_age)
- [count](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_count)
- [none](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_none)
- [pattern](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_pattern)
- [period](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_period)
- [state](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_state)

You can use [environment variables](https://www.elastic.co/docs/reference/elasticsearch/curator/envvars) in your configuration files.