﻿---
title: week_starts_on
description: The value of this setting indicates whether weeks should be measured starting on sunday or monday.  Though Monday is the ISO standard, Sunday is frequently...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/fe_week_starts_on
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# week_starts_on
<note>
  This setting is only used with the [period](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_period) filtertype when [period_type](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_period_type) is `relative`.
</note>

```yaml
 - filtertype: period
   source: name
   range_from: -1
   range_to: -1
   timestring: '%Y.%m.%d'
   unit: weeks
   week_starts_on: sunday
```

The value of this setting indicates whether weeks should be measured starting on `sunday` or `monday`.  Though Monday is the ISO standard, Sunday is frequently preferred.
This setting is only used when [unit](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_unit) is set to `weeks`.
The default value for this setting is `sunday`.