﻿---
title: value filter element
description: The value of this setting is used by kind as follows: prefix: Search the first part of an index name for the provided value, suffix: Search the last part...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/fe_value
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# value filter element
<note>
  This setting is only used with the [pattern](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_pattern) filtertype and is a required setting.  There is a separate [value option](https://www.elastic.co/docs/reference/elasticsearch/curator/option_value) associated with the [allocation action](https://www.elastic.co/docs/reference/elasticsearch/curator/allocation), and the [allocated filtertype](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_allocated).
</note>

The value of this setting is used by [kind](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_kind) as follows:
- `prefix`: Search the first part of an index name for the provided value
- `suffix`: Search the last part of an index name for the provided value
- `regex`: Provide your own regular expression, and Curator will find the matches.
- `timestring`: An strftime string to extrapolate and find indices that match. For example, given a `timestring` of `'%Y.%m.%d'`, matching indices would include `logstash-2016.04.01` and `.marvel-2016.04.01`, but not `myindex-2016-04-01`, as the pattern is different.

<important>
  Whatever you provide for `value` is always going to be a part of a regular expression.  The safest practice is to always encapsulate within single quotes.  For example: `value: '-suffix'`, or `value: 'prefix-'`
</important>

There is no default value. This setting must be set by the user or an exception will be raised, and execution will halt.
<tip>
  There are context-specific examples using `value` in the [kind](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_kind) documentation.
</tip>