﻿---
title: use_age
description: This setting allows filtering of indices by their age after other considerations. The default value of this setting is False 
url: https://www.elastic.co/docs/reference/elasticsearch/curator/fe_use_age
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# use_age
```yaml
- filtertype: count
  count: 10
  use_age: True
  source: creation_date
```

This setting allows filtering of indices by their age *after* other considerations.
The default value of this setting is `False`
<note>
  Use of this setting requires the additional setting, [source](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_source).
</note>

<tip>
  There are context-specific examples using `use_age` in the [count](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_count) and [space](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_space) documentation.
</tip>