﻿---
title: timestring
description: This setting must be a valid Python strftime string.  It is used to match and extract the timestamp in an index or snapshot name. The identifiers that...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/fe_timestring
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# timestring
<note>
  This setting is only used with the [age](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_age) filtertype, or with the [space](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_space) filtertype if [use_age](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_use_age) is set to `True`.
</note>


## strftime

This setting must be a valid Python strftime string.  It is used to match and extract the timestamp in an index or snapshot name.
The identifiers that Curator currently recognizes include:

| Unit | Value                    | Note                                                 |
|------|--------------------------|------------------------------------------------------|
| `%Y` | 4 digit year             |                                                      |
| `%G` | 4 digit year             | use instead of `%Y` when doing ISO Week calculations |
| `%y` | 2 digit year             |                                                      |
| `%m` | 2 digit month            |                                                      |
| `%W` | 2 digit week of the year |                                                      |
| `%V` | 2 digit week of the year | use instead of `%W` when doing ISO Week calculations |
| `%d` | 2 digit day of the month |                                                      |
| `%H` | 2 digit hour             | 24 hour notation                                     |
| `%M` | 2 digit minute           |                                                      |
| `%S` | 2 digit second           |                                                      |
| `%j` | 3 digit day of the year  |                                                      |

These identifiers may be combined with each other, and/or separated from each other with hyphens `-`, periods `.`, underscores `_`, or other characters valid in an index name.
Each identifier must be preceded by a `%` character in the timestring.  For example, an index like `index-2016.04.01` would use a timestring of `'%Y.%m.%d'`.
When [source](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_source) is `name`, this setting must be set by the user or an exception will be raised, and execution will halt. There is no default value.
<admonition title="A word about regular expression matching with timestrings">
  Timestrings are parsed from strftime patterns, like `%Y.%m.%d`, into regular expressions.  For example, `%Y` is 4 digits, so the regular expression for that looks like `\d{{4}}`, and `%m` is 2 digits, so the regular expression is `\d{{2}}`.What this means is that a simple timestring to match year and month, `%Y.%m` will result in a regular expression like this: `^.*\d{{4}}\.\d{{2}}.*$`.  This pattern will match any 4 digits, followed by a period `.`, followed by 2 digits, occurring anywhere in the index name.  This means it *will* match monthly indices, like `index-2016.12`, as well as daily indices, like `index-2017.04.01`, which may not be the intended behavior.To compensate for this, when selecting indices matching a subset of another pattern, use a second filter with `exclude` set to `True`
  ```yaml
  - filtertype: pattern
   kind: timestring
   value: '%Y.%m'
  - filtertype: pattern
   kind: timestring
   value: '%Y.%m.%d'
   exclude: True
  ```
  This will prevent the `%Y.%m` pattern from matching the `%Y.%m` part of the daily indices.**This applies whether using `timestring` as a mere pattern match, or as part of date calculations.**
</admonition>