﻿---
title: source
description: The source from which to derive the index or snapshot age. Can be one of name, creation_date, or field_stats. Using name as the source tells Curator to...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/fe_source
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# source
The *source* from which to derive the index or snapshot age. Can be one of `name`, `creation_date`, or `field_stats`.
<note>
  This setting is only used with the [age](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_age) filtertype, or with the [space](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_space) filtertype when [use_age](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_use_age) is set to `True`.
</note>

<note>
  When using the [age](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_age) filtertype, source requires [direction](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_direction), [unit](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_unit), [unit_count](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_unit_count), and additionally, the optional setting, [epoch](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_epoch).
</note>


## `name`-based ages

Using `name` as the `source` tells Curator to look for a [`timestring`](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_timestring) within the index or snapshot name, and convert that into an epoch timestamp (epoch implies UTC).
```yaml
 - filtertype: age
   source: name
   direction: older
   timestring: '%Y.%m.%d'
   unit: days
   unit_count: 3
```

<admonition title="A word about regular expression matching with timestrings">
  Timestrings are parsed from strftime patterns, like `%Y.%m.%d`, into regular expressions.  For example, `%Y` is 4 digits, so the regular expression for that looks like `\d{{4}}`, and `%m` is 2 digits, so the regular expression is `\d{{2}}`.What this means is that a simple timestring to match year and month, `%Y.%m` will result in a regular expression like this: `^.*\d{{4}}\.\d{{2}}.*$`.  This pattern will match any 4 digits, followed by a period `.`, followed by 2 digits, occurring anywhere in the index name.  This means it *will* match monthly indices, like `index-2016.12`, as well as daily indices, like `index-2017.04.01`, which may not be the intended behavior.To compensate for this, when selecting indices matching a subset of another pattern, use a second filter with `exclude` set to `True`
  ```yaml
  - filtertype: pattern
   kind: timestring
   value: '%Y.%m'
  - filtertype: pattern
   kind: timestring
   value: '%Y.%m.%d'
   exclude: True
  ```
  This will prevent the `%Y.%m` pattern from matching the `%Y.%m` part of the daily indices.**This applies whether using `timestring` as a mere pattern match, or as part of date calculations.**
</admonition>


## `creation_date`-based ages

`creation_date` extracts the epoch time of index or snapshot creation.
```yaml
 - filtertype: age
   source: creation_date
   direction: older
   unit: days
   unit_count: 3
```


## `field_stats`-based ages

<note>
  `source` can only be `field_stats` when filtering indices.
</note>

In Curator 5.3 and older, source `field_stats` uses the [Field Stats API](http://www.elastic.co/guide/en/elasticsearch/reference/5.6/search-field-stats.html) to calculate either the `min_value` or the `max_value` of the [`field`](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_field) as the [`stats_result`](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_stats_result), and then use that value for age comparisons.  In 5.4 and above, even though it is still called `field_stats`, it uses an aggregation to calculate the same values, as the `field_stats` API is no longer used in Elasticsearch 6.x and up.
[`field`](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_field) must be of type `date` in Elasticsearch.
```yaml
 - filtertype: age
   source: field_stats
   direction: older
   unit: days
   unit_count: 3
   field: '@timestamp'
   stats_result: min_value
```