﻿---
title: max_num_segments filter element
description: The value for this setting is the cutoff number of segments per shard.  Indices which have this number of segments per shard, or fewer, will be actionable...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/fe_max_num_segments
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# max_num_segments filter element
<note>
  This setting is only used with the [forcemerged](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_forcemerged) filtertype.
</note>

```yaml
- filtertype: forcemerged
  max_num_segments: 2
  exclude: True
```

The value for this setting is the cutoff number of segments per shard.  Indices which have this number of segments per shard, or fewer, will be actionable depending on the value of [exclude](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_exclude), which is `True` by default for the [forcemerged](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_forcemerged) filter type.
There is no default value. This setting must be set by the user or an exception will be raised, and execution will halt.