﻿---
title: intersect
description: The value of this setting must be True or False. field_stats uses an aggregation query to calculate either the min_value and the max_value of the field...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/fe_intersect
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# intersect
<note>
  This setting is only available in the [period](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_age) filtertype. This setting is strictly optional.
</note>

```yaml
 - filtertype: period
   source: field_stats
   direction: older
   intersect: true
   unit: weeks
   range_from: -1
   range_to: -1
   field: '@timestamp'
   stats_result: min_value
```

The value of this setting must be `True` or `False`.
`field_stats` uses an aggregation query to calculate either the `min_value` and the `max_value` of the [`field`](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_field) as the [`stats_result`](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_stats_result).  If `intersect` is `True`, then only indices where the `min_value` *and* the `max_value` are within the `range_from` and `range_to` (relative to `unit`) will match.  This means that either `min_value` or `max_value` can be used for [`stats_result`](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_stats_result) when `intersect` is `True` with identical results.
This setting is only used when [source](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_source) is `field_stats`.
The default value for this setting is `False`.