﻿---
title: epoch
description: unit, unit_count, and optionally, epoch, are used by Curator to establish the moment in time point of reference with this formula: If epoch is unset,...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/fe_epoch
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# epoch
<note>
  This setting is available in the [age](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_age) filtertype, and any filter which has the [`use_age`](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_use_age) setting. This setting is strictly optional.
</note>

<tip>
  This setting is not common.  It is most frequently used for testing.
</tip>

[unit](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_unit), [unit_count](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_unit_count), and optionally, epoch, are used by Curator to establish the moment in time point of reference with this formula:
```sh
point_of_reference = epoch - ((number of seconds in unit) * unit_count)
```

If epoch is unset, the current time is used. It is possible to set a point of reference in the future by using a negative value for [unit_count](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_unit_count).

## Example

```yaml
 - filtertype: age
   source: creation_date
   direction: older
   unit: days
   unit_count: 3
   epoch: 1491577200
```

The value for this setting must be an epoch timestamp. In this example, the given epoch time of `1491577200` is 2017-04-04T15:00:00Z (UTC).  This will use 3 days older than that timestamp as the point of reference for age comparisons.