﻿---
title: direction
description: This setting must be either older or younger.  This setting is used to determine whether indices or snapshots are older or younger than the reference...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/fe_direction
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# direction
<note>
  This setting is only used with the [age](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_age) filtertype.
</note>

```yaml
 - filtertype: age
   source: creation_date
   direction: older
   unit: days
   unit_count: 3
```

This setting must be either `older` or `younger`.  This setting is used to determine whether indices or snapshots are `older` or `younger` than the reference point in time determined by [unit](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_unit), [unit_count](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_unit_count), and optionally, [epoch](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_epoch).  If `direction` is `older`, then indices (or snapshots) which are *older* than the reference point in time will be matched.  Likewise, if `direction` is `younger`, then indices (or snapshots) which are *younger* than the reference point in time will be matched.
There is no default value. This setting must be set by the user or an exception will be raised, and execution will halt.