﻿---
title: date_to_format
description: The value for this setting should be an strftime string which corresponds to the date in date_to: The identifiers that Curator currently recognizes include:...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/fe_date_to_format
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# date_to_format
<note>
  This setting is only used with the [period](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_period) filtertype when [period_type](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_period_type) is `absolute`.
</note>

```yaml
 - filtertype: period
   period_type: absolute
   source: name
   timestring: '%Y.%m.%d'
   unit: months
   date_from: 2017.01
   date_from_format: '%Y.%m'
   date_to: 2017.01
   date_to_format: '%Y.%m'
```

The value for this setting should be an strftime string which corresponds to the date in [`date_to`](https://www.elastic.co/docs/reference/elasticsearch/curator/fe_date_to):
The identifiers that Curator currently recognizes include:

| Unit | Value                    | Note                                                 |
|------|--------------------------|------------------------------------------------------|
| `%Y` | 4 digit year             |                                                      |
| `%G` | 4 digit year             | use instead of `%Y` when doing ISO Week calculations |
| `%y` | 2 digit year             |                                                      |
| `%m` | 2 digit month            |                                                      |
| `%W` | 2 digit week of the year |                                                      |
| `%V` | 2 digit week of the year | use instead of `%W` when doing ISO Week calculations |
| `%d` | 2 digit day of the month |                                                      |
| `%H` | 2 digit hour             | 24 hour notation                                     |
| `%M` | 2 digit minute           |                                                      |
| `%S` | 2 digit second           |                                                      |
| `%j` | 3 digit day of the year  |                                                      |