﻿---
title: aliases
description: The value of this setting must be a single alias name, or a list of alias names. This can be done in any of the ways YAML allows for lists or arrays...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/fe_aliases
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# aliases
<admonition title="Matching indices and aliases">
  [Indices must be in all aliases to match](https://www.elastic.co/guide/en/elasticsearch/reference/5.5/breaking-changes-5.5.html#breaking_55_rest_changes).If a list of `aliases` is provided (instead of only one), indices must appear in *all* listed `aliases` or a 404 error will result, leading to no indices being matched. In older versions, if the index was associated with even one of the aliases in `aliases`, it would result in a match.
</admonition>

<note>
  This setting is used only when using the [alias](https://www.elastic.co/docs/reference/elasticsearch/curator/filtertype_alias) filter.
</note>

The value of this setting must be a single alias name, or a list of alias names. This can be done in any of the ways YAML allows for lists or arrays.  Here are a few examples.
**Single**
```txt
filters:
- filtertype: alias
  aliases: my_alias
  exclude: False
```

**List**
- Flow style:
  ```txt
  filters:
  - filtertype: alias
    aliases: [ my_alias, another_alias ]
    exclude: False
  ```
- Block style:
  ```txt
  filters:
  - filtertype: alias
    aliases:
      - my_alias
      - another_alias
    exclude: False
  ```

There is no default value. This setting must be set by the user or an exception will be raised, and execution will halt.