﻿---
title: Delete Snapshots
description: This action deletes the selected snapshots from the selected repository.  If a snapshot is currently underway, Curator will retry up to retry_count times,...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/delete_snapshots
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# Delete Snapshots
```yaml
action: delete_snapshots
description: "Delete selected snapshots from 'repository'"
options:
  repository: ...
  retry_interval: 120
  retry_count: 3
filters:
- filtertype: ...
```

<note>
  Empty values and commented lines will result in the default value, if any, being selected.  If a setting is set, but not used by a given action, it will be ignored.
</note>

This action deletes the selected snapshots from the selected [repository](https://www.elastic.co/docs/reference/elasticsearch/curator/option_repository).  If a snapshot is currently underway, Curator will retry up to [retry_count](https://www.elastic.co/docs/reference/elasticsearch/curator/option_retry_count) times, with a delay of [retry_interval](https://www.elastic.co/docs/reference/elasticsearch/curator/option_retry_interval) seconds between retries.

## Required settings

- [repository](https://www.elastic.co/docs/reference/elasticsearch/curator/option_repository)


## Optional settings

- [retry_interval](https://www.elastic.co/docs/reference/elasticsearch/curator/option_retry_interval)
- [retry_count](https://www.elastic.co/docs/reference/elasticsearch/curator/option_retry_count)
- [ignore_empty_list](https://www.elastic.co/docs/reference/elasticsearch/curator/option_ignore_empty)
- [timeout_override](https://www.elastic.co/docs/reference/elasticsearch/curator/option_timeout_override)
- [continue_if_exception](https://www.elastic.co/docs/reference/elasticsearch/curator/option_continue)
- [disable_action](https://www.elastic.co/docs/reference/elasticsearch/curator/option_disable)

<tip>
  See an example of this action in an [actionfile](https://www.elastic.co/docs/reference/elasticsearch/curator/actionfile) [here](https://www.elastic.co/docs/reference/elasticsearch/curator/ex_delete_snapshots).
</tip>