﻿---
title: Delete Indices
description: This action deletes the selected indices. In clusters which are overcrowded with indices, or a high number of shards per node, deletes can take a longer...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/delete_indices
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# Delete Indices
```yaml
action: delete_indices
description: "Delete selected indices"
options:
  continue_if_exception: False
filters:
- filtertype: ...
```

<note>
  Empty values and commented lines will result in the default value, if any, being selected.  If a setting is set, but not used by a given action, it will be ignored.
</note>

This action deletes the selected indices.
In clusters which are overcrowded with indices, or a high number of shards per node, deletes can take a longer time to process.  In such cases, it may be helpful to set a higher timeout than is set in the [configuration file](https://www.elastic.co/docs/reference/elasticsearch/curator/configfile).  You can override that [request_timeout](/docs/reference/elasticsearch/curator/configfile#request_timeout) as follows:
```yaml
action: delete_indices
description: "Delete selected indices"
options:
  timeout_override: 300
  continue_if_exception: False
filters:
- filtertype: ...
```


## Optional settings

- [search_pattern](https://www.elastic.co/docs/reference/elasticsearch/curator/option_search_pattern)
- [ignore_empty_list](https://www.elastic.co/docs/reference/elasticsearch/curator/option_ignore_empty)
- [timeout_override](https://www.elastic.co/docs/reference/elasticsearch/curator/option_timeout_override)
- [continue_if_exception](https://www.elastic.co/docs/reference/elasticsearch/curator/option_continue)
- [disable_action](https://www.elastic.co/docs/reference/elasticsearch/curator/option_disable)

<tip>
  See an example of this action in an [actionfile](https://www.elastic.co/docs/reference/elasticsearch/curator/actionfile) [here](https://www.elastic.co/docs/reference/elasticsearch/curator/ex_delete_indices).
</tip>