﻿---
title: Create Index
description: This action creates the named index.  There are multiple different ways to configure how the name is represented. In this case, what you see is what you...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/create_index
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# Create Index
```yaml
action: create_index
description: "Create index as named"
options:
  name: ...
```

<note>
  Empty values and commented lines will result in the default value, if any, being selected.  If a setting is set, but not used by a given action, it will be ignored.
</note>

This action creates the named index.  There are multiple different ways to configure how the name is represented.

## Manual naming

```yaml
action: create_index
description: "Create index as named"
options:
  name: myindex
  # ...
```

In this case, what you see is what you get. An index named `myindex` will be created

## Python strftime

```yaml
action: create_index
description: "Create index as named"
options:
  name: 'myindex-%Y.%m'
  # ...
```

For the `create_index` action, the [name](https://www.elastic.co/docs/reference/elasticsearch/curator/option_name) option can contain Python strftime strings.  The method for doing so is described in detail, including which strftime strings are acceptable, in the documentation for the [name](https://www.elastic.co/docs/reference/elasticsearch/curator/option_name) option.

## Date Math

```yaml
action: create_index
description: "Create index as named"
options:
  name: '<logstash-{now/d+1d}>'
  # ...
```

For the `create_index` action, the [name](https://www.elastic.co/docs/reference/elasticsearch/curator/option_name) option can be in Elasticsearch [date math](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/api-conventions#api-date-math-index-names) format. This allows index names containing dates to use deterministic math to set a date name in the past or the future.
For example, if today’s date were 2017-03-27, the name `<logstash-{now/d}>` will create an index named `logstash-2017.03.27`. If you wanted to create *tomorrow’s* index, you would use the name `<logstash-{now/d+1d}>`, which adds 1 day.  This pattern creates an index named `logstash-2017.03.28`.  For many more configuration options, read the Elasticsearch [date math]((elasticsearch:///reference/elasticsearch/rest-apis/api-conventions.md#api-date-math-index-names) documentation.

## Extra Settings

The [extra_settings](https://www.elastic.co/docs/reference/elasticsearch/curator/option_extra_settings) option allows the addition of extra settings, such as index settings and mappings.  An example of how these settings can be used to create an index might be:
```yaml
action: create_index
description: "Create index as named"
options:
  name: myindex
  # ...
  extra_settings:
    settings:
      number_of_shards: 1
      number_of_replicas: 0
    mappings:
      type1:
        properties:
          field1:
            type: string
            index: not_analyzed
```


## Required settings

- [name](https://www.elastic.co/docs/reference/elasticsearch/curator/option_name)


## Optional settings

- [extra_settings](https://www.elastic.co/docs/reference/elasticsearch/curator/option_extra_settings) No default value.  You can add any acceptable index settings and mappings as nested YAML.  See the [Create an index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) for more information.
- [timeout_override](https://www.elastic.co/docs/reference/elasticsearch/curator/option_timeout_override)
- [continue_if_exception](https://www.elastic.co/docs/reference/elasticsearch/curator/option_continue)
- [disable_action](https://www.elastic.co/docs/reference/elasticsearch/curator/option_disable)

<tip>
  See an example of this action in an [actionfile](https://www.elastic.co/docs/reference/elasticsearch/curator/actionfile) [here](https://www.elastic.co/docs/reference/elasticsearch/curator/ex_create_index).
</tip>