﻿---
title: Cluster Routing
description: This action changes the shard routing allocation for the selected indices. See Cluster-level shard allocation and routing settings for more information...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/cluster_routing
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# Cluster Routing
```yaml
action: cluster_routing
description: "Apply routing rules to the entire cluster"
options:
  routing_type:
  value: ...
  setting: enable
```

<note>
  Empty values and commented lines will result in the default value, if any, being selected.  If a setting is set, but not used by a given action, it will be ignored.
</note>

This action changes the shard routing allocation for the selected indices.
See [Cluster-level shard allocation and routing settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/cluster-level-shard-allocation-routing-settings) for more information.
You can optionally set `wait_for_completion` to `True` to have Curator wait for the shard routing to complete before continuing:
```yaml
action: cluster_routing
description: "Apply routing rules to the entire cluster"
options:
  routing_type:
  value: ...
  setting: enable
  wait_for_completion: True
  max_wait: 300
  wait_interval: 10
```

This configuration will wait for a maximum of 300 seconds for shard routing and reallocation to complete before giving up.  A `max_wait` value of `-1` will wait indefinitely.  Curator will poll for completion at `10` second intervals, as defined by `wait_interval`.

## Required settings

- [routing_type](https://www.elastic.co/docs/reference/elasticsearch/curator/option_routing_type)
- [value](https://www.elastic.co/docs/reference/elasticsearch/curator/option_value)
- [setting](https://www.elastic.co/docs/reference/elasticsearch/curator/option_setting) Currently must be set to `enable`.  This setting is a placeholder for potential future expansion.


## Optional settings

- [wait_for_completion](https://www.elastic.co/docs/reference/elasticsearch/curator/option_wfc)
- [max_wait](https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_wait)
- [wait_interval](https://www.elastic.co/docs/reference/elasticsearch/curator/option_wait_interval)
- [timeout_override](https://www.elastic.co/docs/reference/elasticsearch/curator/option_timeout_override)
- [continue_if_exception](https://www.elastic.co/docs/reference/elasticsearch/curator/option_continue)
- [disable_action](https://www.elastic.co/docs/reference/elasticsearch/curator/option_disable)

<tip>
  See an example of this action in an [actionfile](https://www.elastic.co/docs/reference/elasticsearch/curator/actionfile) [here](https://www.elastic.co/docs/reference/elasticsearch/curator/ex_cluster_routing).
</tip>