﻿---
title: Curator close action for Elasticsearch indices
description: This action closes the selected indices, and optionally deletes associated aliases beforehand. search_pattern, delete_aliases, skip_flush, ignore_empty_list,...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/close
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# Curator close action for Elasticsearch indices
```yaml
action: close
description: "Close selected indices"
options:
  delete_aliases: false
  skip_flush: false
filters:
- filtertype: ...
```

<note>
  Empty values and commented lines will result in the default value, if any, being selected.  If a setting is set, but not used by a given action, it will be ignored.
</note>

This action closes the selected indices, and optionally deletes associated aliases beforehand.

## Optional settings

- [search_pattern](https://www.elastic.co/docs/reference/elasticsearch/curator/option_search_pattern)
- [delete_aliases](https://www.elastic.co/docs/reference/elasticsearch/curator/option_delete_aliases)
- [skip_flush](https://www.elastic.co/docs/reference/elasticsearch/curator/option_skip_flush)
- [ignore_empty_list](https://www.elastic.co/docs/reference/elasticsearch/curator/option_ignore_empty)
- [timeout_override](https://www.elastic.co/docs/reference/elasticsearch/curator/option_timeout_override)
- [continue_if_exception](https://www.elastic.co/docs/reference/elasticsearch/curator/option_continue)
- [disable_action](https://www.elastic.co/docs/reference/elasticsearch/curator/option_disable)

<tip>
  See an example of this action in an [actionfile](https://www.elastic.co/docs/reference/elasticsearch/curator/actionfile) [here](https://www.elastic.co/docs/reference/elasticsearch/curator/ex_close).
</tip>