﻿---
title: Using the allocation action in Elasticsearch Curator
description: This action changes the shard routing allocation for the selected indices. See Index-level shard allocation for more information. You can optionally set...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/allocation
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# Using the allocation action in Elasticsearch Curator
```yaml
action: allocation
description: "Apply shard allocation filtering rules to the specified indices"
options:
  key: ...
  value: ...
  allocation_type: ...
filters:
- filtertype: ...
```

<note>
  Empty values and commented lines will result in the default value, if any, being selected.  If a setting is set, but not used by a given action, it will be ignored.
</note>

This action changes the shard routing allocation for the selected indices.
See [Index-level shard allocation](https://www.elastic.co/docs/deploy-manage/distributed-architecture/shard-allocation-relocation-recovery/index-level-shard-allocation) for more information.
You can optionally set `wait_for_completion` to `True` to have Curator wait for the shard routing to complete before continuing:
```yaml
action: allocation
description: "Apply shard allocation filtering rules to the specified indices"
options:
  key: ...
  value: ...
  allocation_type: ...
  wait_for_completion: True
  max_wait: 300
  wait_interval: 10
filters:
- filtertype: ...
```

This configuration will wait for a maximum of 300 seconds for shard routing and reallocation to complete before giving up.  A `max_wait` value of `-1` will wait indefinitely.  Curator will poll for completion at `10` second intervals, as defined by `wait_interval`.

## Required settings

- [key](https://www.elastic.co/docs/reference/elasticsearch/curator/option_key)


## Optional settings

- [search_pattern](https://www.elastic.co/docs/reference/elasticsearch/curator/option_search_pattern)
- [allocation_type](https://www.elastic.co/docs/reference/elasticsearch/curator/option_allocation_type)
- [value](https://www.elastic.co/docs/reference/elasticsearch/curator/option_value)
- [wait_for_completion](https://www.elastic.co/docs/reference/elasticsearch/curator/option_wfc)
- [max_wait](https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_wait)
- [wait_interval](https://www.elastic.co/docs/reference/elasticsearch/curator/option_wait_interval)
- [ignore_empty_list](https://www.elastic.co/docs/reference/elasticsearch/curator/option_ignore_empty)
- [timeout_override](https://www.elastic.co/docs/reference/elasticsearch/curator/option_timeout_override)
- [continue_if_exception](https://www.elastic.co/docs/reference/elasticsearch/curator/option_continue)
- [disable_action](https://www.elastic.co/docs/reference/elasticsearch/curator/option_disable)

<tip>
  See an example of this action in an [actionfile](https://www.elastic.co/docs/reference/elasticsearch/curator/actionfile) [here](https://www.elastic.co/docs/reference/elasticsearch/curator/ex_allocation).
</tip>