﻿---
title: Alias action in Elasticsearch Curator
description: This action adds and/or removes indices from the alias identified by name The filters under the add and remove directives define which indices will be...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/alias
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# Alias action in Elasticsearch Curator
```yaml
action: alias
description: "Add/Remove selected indices to or from the specified alias"
options:
  name: alias_name
add:
  filters:
  - filtertype: ...
remove:
  filters:
  - filtertype: ...
```

<note>
  Empty values and commented lines will result in the default value, if any, being selected.  If a setting is set, but not used by a given action, it will be ignored.
</note>

This action adds and/or removes indices from the alias identified by [name](https://www.elastic.co/docs/reference/elasticsearch/curator/option_name)
The [filters](https://www.elastic.co/docs/reference/elasticsearch/curator/filters) under the `add` and `remove` directives define which indices will be added and/or removed.  This is an atomic action, so adds and removes happen instantaneously.
The [extra_settings](https://www.elastic.co/docs/reference/elasticsearch/curator/option_extra_settings) option allows the addition of extra settings with the `add` directive.  These settings are ignored for `remove`.  An example of how these settings can be used to create a filtered alias might be:
```yaml
action: alias
description: "Add/Remove selected indices to or from the specified alias"
options:
  name: alias_name
  extra_settings:
    filter:
      term:
        user: kimchy
add:
  filters:
  - filtertype: ...
remove:
  filters:
  - filtertype: ...
```

<warning>
  Before creating a filtered alias, first ensure that the fields already exist in the mapping.
</warning>

[Learn more about adding filtering and routing to aliases](https://www.elastic.co/docs/manage-data/data-store/aliases).

## Required settings

- [name](https://www.elastic.co/docs/reference/elasticsearch/curator/option_name)


## Optional settings

- [warn_if_no_indices](https://www.elastic.co/docs/reference/elasticsearch/curator/option_warn_if_no_indices)
- [extra_settings](https://www.elastic.co/docs/reference/elasticsearch/curator/option_extra_settings)
- [ignore_empty_list](https://www.elastic.co/docs/reference/elasticsearch/curator/option_ignore_empty)
- [timeout_override](https://www.elastic.co/docs/reference/elasticsearch/curator/option_timeout_override)
- [continue_if_exception](https://www.elastic.co/docs/reference/elasticsearch/curator/option_continue)
- [disable_action](https://www.elastic.co/docs/reference/elasticsearch/curator/option_disable)

<tip>
  See an example of this action in an [actionfile](https://www.elastic.co/docs/reference/elasticsearch/curator/actionfile) [here](https://www.elastic.co/docs/reference/elasticsearch/curator/ex_alias).
</tip>