﻿---
title: Features
description: Curator allows for many different operations to be performed to both indices and snapshots, including: Add or remove indices (or both!) from an alias,...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/about-features
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# Features
Curator allows for many different operations to be performed to both indices and snapshots, including:
- Add or remove indices (or both!) from an [alias](https://www.elastic.co/docs/reference/elasticsearch/curator/alias)
- Change shard routing [allocation](https://www.elastic.co/docs/reference/elasticsearch/curator/allocation)
- [Close](https://www.elastic.co/docs/reference/elasticsearch/curator/close) indices
- [Create index](https://www.elastic.co/docs/reference/elasticsearch/curator/create_index)
- [Delete indices](https://www.elastic.co/docs/reference/elasticsearch/curator/delete_indices)
- [Delete snapshots](https://www.elastic.co/docs/reference/elasticsearch/curator/delete_snapshots)
- [Open](https://www.elastic.co/docs/reference/elasticsearch/curator/open) closed indices
- [forceMerge](https://www.elastic.co/docs/reference/elasticsearch/curator/forcemerge) indices
- [reindex](https://www.elastic.co/docs/reference/elasticsearch/curator/reindex) indices, including from remote clusters
- Change the number of [replicas](https://www.elastic.co/docs/reference/elasticsearch/curator/replicas) per shard for indices
- [rollover](https://www.elastic.co/docs/reference/elasticsearch/curator/rollover) indices
- Take a [snapshot](https://www.elastic.co/docs/reference/elasticsearch/curator/snapshot) (backup) of indices
- [Restore](https://www.elastic.co/docs/reference/elasticsearch/curator/restore) snapshots
- [Shrink](https://www.elastic.co/docs/reference/elasticsearch/curator/shrink) indices