﻿---
title: Transforms  settings in Elasticsearch
description: You do not need to configure any settings to use transforms. It is enabled by default. 
url: https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/transforms-settings
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Transforms  settings in Elasticsearch
You do not need to configure any settings to use transforms. It is enabled by default.

## General transforms settings

<definitions>
  <definition term="node.roles: [ transform ]">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Set `node.roles` to contain `transform` to identify the node as a *transform node*. If you want to run transforms, there must be at least one transform node in your cluster.
    If you set `node.roles`, you must explicitly specify all the required roles for the node. To learn more, refer to [Node settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/node-settings).
    <important>
      It is strongly recommended that dedicated transform nodes also have the `remote_cluster_client` role; otherwise, cross-cluster search fails when used in transforms. See [Remote-eligible node](https://www.elastic.co/docs/deploy-manage/distributed-architecture/clusters-nodes-shards/node-roles#remote-node).
    </important>
  </definition>
  <definition term="xpack.transform.enabled">
    <admonition title="Deprecated in 7.8.0">
      This deprecated setting no longer has any effect.
    </admonition>
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting))
  </definition>
  <definition term="xpack.transform.num_transform_failure_retries">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) The number of times that a transform retries when it experiences a non-fatal error. Once the number of retries is exhausted, the transform task is marked as `failed`. The default value is `10` with a valid minimum of `0` and maximum of `100`. If a transform is already running, it has to be restarted to use the changed setting. The `num_failure_retries` setting can also be specified on an individual transform level. Specifying this setting for each transform individually is recommended.
  </definition>
</definitions>