﻿---
title: Snapshot and restore settings
description: The following cluster settings configure snapshot and restore. The following cluster settings configure snapshot lifecycle management (SLM). 
url: https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/snapshot-restore-settings
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Snapshot and restore settings
The following cluster settings configure [snapshot and restore](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore).

<definitions>
  <definition term="snapshot.max_concurrent_operations">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting), integer) Maximum number of concurrent snapshot operations. Defaults to `1000`.
    This limit applies in total to all ongoing snapshot creation, cloning, and deletion operations. Elasticsearch will reject any operations that would exceed this limit.
  </definition>
  <definition term="azure.client.CLIENT_NAME.endpoint_suffix logo cloud">
    Allows providing the [endpoint_suffix client setting](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/azure-repository#repository-azure-client-settings) for a non-internal Azure client used for snapshot/restore. Note that `CLIENT_NAME` should be replaced with the name of the created client.
  </definition>
</definitions>


## SLM settings

The following cluster settings configure [snapshot lifecycle management (SLM)](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/create-snapshots#automate-snapshots-slm).

<definitions>
  <definition term="slm.history_index_enabled">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting), Boolean) Controls whether SLM records the history of actions taken as part of SLM policies to the `slm-history-*` indices. Defaults to `true`.
  </definition>
</definitions>


<definitions>
  <definition term="slm.retention_schedule">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting), [cron scheduler value](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/schedule-types#schedule-cron)) Controls when the [retention task](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/create-snapshots#slm-retention-task) runs. Can be a periodic or absolute time schedule. Supports all values supported by the [cron scheduler](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/schedule-types#schedule-cron). Defaults to daily at 1:30am UTC: `0 30 1 * * ?`.
  </definition>
</definitions>


<definitions>
  <definition term="slm.retention_duration">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting), [time value](/docs/reference/elasticsearch/rest-apis/api-conventions#time-units)) Limits how long SLM should spend deleting old snapshots. Defaults to one hour: `1h`.
  </definition>
</definitions>


<definitions>
  <definition term="slm.health.failed_snapshot_warn_threshold">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting), Long) The number of failed invocations since last successful snapshot that indicate a problem with the policy in the health api. Defaults to a health api warning after five repeated failures: `5L`.
  </definition>
</definitions>


<definitions>
  <definition term="repositories.url.allowed_urls logo cloud">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Specifies the [read-only URL repositories](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/read-only-url-repository) that snapshots can be restored from. The default value is an empty list.
  </definition>
</definitions>