﻿---
title: Shard request cache settings
description: The following settings affect the behavior of the shard request cache. 
url: https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/shard-request-cache-settings
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Shard request cache settings
The following settings affect the behavior of the [shard request cache](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/shard-request-cache).

## Cache settings

<definitions>
  <definition term="indices.requests.cache.size">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) The maximum size of the cache, as a percentage of the heap. Default: `1%`.
  </definition>
  <definition term="indices.requests.cache.expire">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) The TTL for cached results. Stale results are automatically invalidated when the index is refreshed, so you shouldn’t need to use this setting.
  </definition>
</definitions>