﻿---
title: Search settings
description: The following expert settings can be set to manage global search and aggregation limits. The following search settings are supported: search.aggs.rewrite_to_filter_by_filter...
url: https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/search-settings
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Search settings
The following expert settings can be set to manage global search and aggregation limits.

<definitions>
  <definition term="indices.query.bool.max_clause_count">
    <admonition title="Deprecated in 8.0.0">
      This deprecated setting has no effect.
    </admonition>
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting), integer) Elasticsearch will now dynamically set the maximum number of allowed clauses in a query, using a heuristic based on the size of the search thread pool and the size of the heap allocated to the JVM. This limit has a minimum value of 1024 and will in most cases be larger (for example, a node with 30Gb RAM and 48 CPUs will have a maximum clause count of around 27,000). Larger heaps lead to higher values, and larger thread pools result in lower values.
    Queries with many clauses should be avoided whenever possible. If you previously bumped this setting to accommodate heavy queries, you might need to increase the amount of memory available to Elasticsearch, or to reduce the size of your search thread pool so that more memory is available to each concurrent search.
    In previous versions of Lucene you could get around this limit by nesting boolean queries within each other, but the limit is now based on the total number of leaf queries within the query as a whole and this workaround will no longer help.
  </definition>
</definitions>


<definitions>
  <definition term="search.max_buckets">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting), integer) Maximum number of [aggregation buckets](https://www.elastic.co/docs/reference/aggregations/bucket) allowed in a single response. Defaults to 65,536.
    Requests that attempt to return more than this limit will return an error.
  </definition>
</definitions>


<definitions>
  <definition term="search.aggs.only_allowed_metric_scripts">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting), boolean) Configures whether only explicitly allowed scripts can be used in [scripted metrics aggregations](https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-scripted-metric-aggregation). Defaults to `false`.
    Requests using scripts not contained in either [`search.aggs.allowed_inline_metric_scripts`](#search-settings-allowed-inline-scripts) or [`search.aggs.allowed_stored_metric_scripts`](#search-settings-allowed-stored-scripts) will return an error.
  </definition>
</definitions>


<definitions>
  <definition term="search.aggs.allowed_inline_metric_scripts">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting), list of strings) List of inline scripts that can be used in scripted metrics aggregations when [`search.aggs.only_allowed_metric_scripts`](#search-settings-only-allowed-scripts) is set to `true`. Defaults to an empty list.
    Requests using other inline scripts will return an error.
  </definition>
</definitions>


<definitions>
  <definition term="search.aggs.allowed_stored_metric_scripts">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting), list of strings) List of ids of stored scripts that can be used in scripted metrics aggregations when [`search.aggs.only_allowed_metric_scripts`](#search-settings-only-allowed-scripts) is set to `true`. Defaults to an empty list.
    Requests using other stored scripts will return an error.
  </definition>
</definitions>


<definitions>
  <definition term="indices.query.bool.max_nested_depth">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting), integer) Maximum nested depth of queries. Defaults to `30`.
    This setting limits the nesting depth of queries. Deep nesting of queries may lead to stack overflow errors.
  </definition>
</definitions>

The following search settings are supported:
- `search.aggs.rewrite_to_filter_by_filter`