﻿---
title: Monitoring settings in Elasticsearch
description: By default, Elasticsearch monitoring features are enabled but data collection is disabled. To enable data collection, use the xpack.monitoring.collection.enabled...
url: https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/monitoring-settings
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Monitoring settings in Elasticsearch
<admonition title="Deprecated in 7.16.">
  Using the Elasticsearch Monitoring plugin to collect and ship monitoring data is deprecated. Elastic Agent and Metricbeat are the recommended methods for collecting and shipping monitoring data to a monitoring cluster. If you previously configured legacy collection methods, you should migrate to using [Elastic Agent](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/collecting-monitoring-data-with-elastic-agent) or [Metricbeat](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/collecting-monitoring-data-with-metricbeat) collection methods.
</admonition>

By default, Elasticsearch monitoring features are enabled but data collection is disabled. To enable data collection, use the `xpack.monitoring.collection.enabled` setting.
Except where noted otherwise, these settings can be dynamically updated on a live cluster with the [cluster-update-settings](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-put-settings) API.
To adjust how monitoring data is displayed in the monitoring UI, configure [`xpack.monitoring` settings](https://www.elastic.co/docs/reference/kibana/configuration-reference/monitoring-settings) in `kibana.yml`. To control how monitoring data is collected from Logstash, configure monitoring settings in `logstash.yml`.
For more information, see [Monitor a cluster](https://www.elastic.co/docs/deploy-manage/monitor).

### General monitoring settings

<definitions>
  <definition term="xpack.monitoring.enabled">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting))
    <admonition title="Deprecated in 7.8.0">
      This deprecated setting has no effect.
    </admonition>
  </definition>
</definitions>


### Monitoring collection settings


The `xpack.monitoring.collection` settings control how data is collected from your Elasticsearch nodes.
<definitions>
  <definition term="xpack.monitoring.collection.enabled">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) Set to `true` to enable the collection of monitoring data. When this setting is `false` (default), Elasticsearch monitoring data is not collected and all monitoring data from other sources such as Kibana, Beats, and Logstash is ignored.
  </definition>
</definitions>


<definitions>
  <definition term="xpack.monitoring.collection.interval logo cloud">
    <admonition title="Deprecated in 6.3.0">
      This setting was deprecated in 6.3.0.
    </admonition>
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) Setting to `-1` to disable data collection is no longer supported beginning with 7.0.0.
    Controls how often data samples are collected. Defaults to `10s`. If you modify the collection interval, set the `xpack.monitoring.min_interval_seconds` option in `kibana.yml` to the same value.
  </definition>
  <definition term="xpack.monitoring.elasticsearch.collection.enabled">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) Controls whether statistics about your Elasticsearch cluster should be collected. Defaults to `true`. This is different from `xpack.monitoring.collection.enabled`, which allows you to enable or disable all monitoring collection. However, this setting simply disables the collection of Elasticsearch data while still allowing other data (e.g., Kibana, Logstash, Beats, or APM Server monitoring data) to pass through this cluster.
  </definition>
  <definition term="xpack.monitoring.collection.cluster.stats.timeout">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) Timeout for collecting the cluster statistics, in [time units](/docs/reference/elasticsearch/rest-apis/api-conventions#time-units). Defaults to `10s`.
  </definition>
  <definition term="xpack.monitoring.collection.node.stats.timeout">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) Timeout for collecting the node statistics, in [time units](/docs/reference/elasticsearch/rest-apis/api-conventions#time-units). Defaults to `10s`.
  </definition>
  <definition term="xpack.monitoring.collection.indices">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) Controls which indices the monitoring features collect data from. Defaults to all indices. Specify the index names as a comma-separated list, for example `test1,test2,test3`. Names can include wildcards, for example `test*`. You can explicitly exclude indices by prepending `-`. For example `test*,-test3` will monitor all indexes that start with `test` except for `test3`. System indices like .security* or .kibana* always start with a `.` and generally should be monitored. Consider adding `.*` to the list of indices ensure monitoring of system indices. For example: `.*,test*,-test3`
  </definition>
  <definition term="xpack.monitoring.collection.index.stats.timeout">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) Timeout for collecting index statistics, in [time units](/docs/reference/elasticsearch/rest-apis/api-conventions#time-units). Defaults to `10s`.
  </definition>
  <definition term="xpack.monitoring.collection.index.recovery.active_only">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) Controls whether or not all recoveries are collected. Set to `true` to collect only active recoveries. Defaults to `false`.
  </definition>
  <definition term="xpack.monitoring.collection.index.recovery.timeout">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) Timeout for collecting the recovery information, in [time units](/docs/reference/elasticsearch/rest-apis/api-conventions#time-units). Defaults to `10s`.
  </definition>
  <definition term="xpack.monitoring.collection.min_interval_seconds logo cloud">
    Specifies the minimum number of seconds that a time bucket in a chart can represent. If you modify the `xpack.monitoring.collection.interval`, use the same value in this setting.
    Defaults to `10` (10 seconds).
  </definition>
</definitions>


<definitions>
  <definition term="xpack.monitoring.history.duration logo cloud">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) Retention duration beyond which the indices created by a monitoring exporter are automatically deleted, in [time units](/docs/reference/elasticsearch/rest-apis/api-conventions#time-units). Defaults to `7d` (7 days).
    This setting has a minimum value of `1d` (1 day) to ensure that something is being monitored and it cannot be disabled.
    <important>
      This setting currently impacts only `local`-type exporters. Indices created using the `http` exporter are not deleted automatically.
    </important>
  </definition>
  <definition term="xpack.monitoring.exporters">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Configures where the agent stores monitoring data. By default, the agent uses a local exporter that indexes monitoring data on the cluster where it is installed. Use an HTTP exporter to send data to a separate monitoring cluster. For more information, see [Local exporter settings](#local-exporter-settings), [HTTP exporter settings](#http-exporter-settings), and [How it works](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring).
  </definition>
</definitions>


### Local exporter settings

The `local` exporter is the default exporter used by monitoring features. As the name is meant to imply, it exports data to the *local* cluster, which means that there is not much needed to be configured.
If you do not supply *any* exporters, then the monitoring features automatically create one for you. If any exporter is provided, then no default is added.
```yaml
xpack.monitoring.exporters.my_local:
  type: local
```

<definitions>
  <definition term="type">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    The value for a Local exporter must always be `local` and it is required.
  </definition>
  <definition term="use_ingest">
    Whether to supply a placeholder pipeline to the cluster and a pipeline processor with every bulk request. The default value is `true`. If disabled, then it means that it will not use pipelines, which means that a future release cannot automatically upgrade bulk requests to future-proof them.
  </definition>
  <definition term="cluster_alerts.management.enabled">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    Whether to create cluster alerts for this cluster. The default value is `true`. To use this feature, Watcher must be enabled. If you have a basic license, cluster alerts are not displayed.
  </definition>
  <definition term="wait_master.timeout">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
  </definition>
</definitions>

Time to wait for the master node to setup `local` exporter for monitoring, in [time units](/docs/reference/elasticsearch/rest-apis/api-conventions#time-units). After that wait period, the non-master nodes warn the user for possible missing configuration. Defaults to `30s`.

### HTTP exporter settings

The following lists settings that can be supplied with the `http` exporter. All settings are shown as what follows the name you select for your exporter:
```yaml
xpack.monitoring.exporters.my_remote:
  type: http
  host: ["host:port", ...]
```

<definitions>
  <definition term="type">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    The value for an HTTP exporter must always be `http` and it is required.
  </definition>
  <definition term="host">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    Host supports multiple formats, both as an array or as a single value. Supported formats include `hostname`, `hostname:port`, `http://hostname` `http://hostname:port`, `https://hostname`, and `https://hostname:port`. Hosts cannot be assumed. The default scheme is always `http` and the default port is always `9200` if not supplied as part of the `host` string.
    ```yaml
    xpack.monitoring.exporters:
      example1:
        type: http
        host: "10.1.2.3"
      example2:
        type: http
        host: ["<HOST_IP>"]
      example3:
        type: http
        host: ["10.1.2.5", "10.1.2.6"]
      example4:
        type: http
        host: ["HOST_IP>:9200"]
    ```
  </definition>
  <definition term="auth.username">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    The username is required if `auth.secure_password` is supplied.
  </definition>
  <definition term="auth.secure_password">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Secure](https://www.elastic.co/docs/deploy-manage/security/secure-settings), [reloadable](https://www.elastic.co/docs/deploy-manage/security/secure-settings#reloadable-secure-settings)) The password for the `auth.username`.
  </definition>
  <definition term="connection.timeout">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    Amount of time that the HTTP connection is supposed to wait for a socket to open for the request, in [time units](/docs/reference/elasticsearch/rest-apis/api-conventions#time-units). The default value is `6s`.
  </definition>
  <definition term="connection.read_timeout">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    Amount of time that the HTTP connection is supposed to wait for a socket to send back a response, in [time units](/docs/reference/elasticsearch/rest-apis/api-conventions#time-units). The default value is `10 * connection.timeout` (`60s` if neither are set).
  </definition>
  <definition term="ssl">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    Each HTTP exporter can define its own TLS / SSL settings or inherit them. See [X-Pack monitoring TLS/SSL settings](#ssl-monitoring-settings).
  </definition>
  <definition term="proxy.base_path">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    The base path to prefix any outgoing request, such as `/base/path` (e.g., bulk requests would then be sent as `/base/path/_bulk`). There is no default value.
  </definition>
  <definition term="headers">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    Optional headers that are added to every request, which can assist with routing requests through proxies.
    ```yaml
    xpack.monitoring.exporters.my_remote:
      headers:
        X-My-Array: [abc, def, xyz]
        X-My-Header: abc123
    ```
    Array-based headers are sent `n` times where `n` is the size of the array. `Content-Type` and `Content-Length` cannot be set. Any headers created by the monitoring agent will override anything defined here.
  </definition>
  <definition term="index.name.time_format">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    A mechanism for changing the default date suffix for daily monitoring indices. The default format is `yyyy.MM.dd`. For example, `.monitoring-es-7-2021.08.26`.
  </definition>
  <definition term="use_ingest">
    Whether to supply a placeholder pipeline to the monitoring cluster and a pipeline processor with every bulk request. The default value is `true`. If disabled, then it means that it will not use pipelines, which means that a future release cannot automatically upgrade bulk requests to future-proof them.
  </definition>
  <definition term="cluster_alerts.management.enabled">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    Whether to create cluster alerts for this cluster. The default value is `true`. To use this feature, Watcher must be enabled. If you have a basic license, cluster alerts are not displayed.
  </definition>
  <definition term="cluster_alerts.management.blacklist">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    Prevents the creation of specific cluster alerts. It also removes any applicable watches that already exist in the current cluster.
    You can add any of the following watch identifiers to the list of blocked alerts:
    - `elasticsearch_cluster_status`
    - `elasticsearch_version_mismatch`
    - `elasticsearch_nodes`
    - `kibana_version_mismatch`
    - `logstash_version_mismatch`
    - `xpack_license_expiration`
    For example: `["elasticsearch_version_mismatch","xpack_license_expiration"]`.
  </definition>
</definitions>


## X-Pack monitoring TLS/SSL settings

You can configure the following TLS/SSL settings.
<definitions>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.supported_protocols">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Supported protocols with versions. Valid protocols: `SSLv2Hello`, `SSLv3`, `TLSv1`, `TLSv1.1`, `TLSv1.2`, `TLSv1.3`. If the JVM’s SSL provider supports TLSv1.3, the default is `TLSv1.3,TLSv1.2,TLSv1.1`. Otherwise, the default is `TLSv1.2,TLSv1.1`.
    Elasticsearch relies on your JDK’s implementation of SSL and TLS. View [Supported SSL/TLS versions by JDK version](https://www.elastic.co/docs/deploy-manage/security/supported-ssltls-versions-by-jdk-version) for more information.
    <note>
      If `xpack.security.fips_mode.enabled` is `true`, you cannot use `SSLv2Hello` or `SSLv3`. See [FIPS 140-2](https://www.elastic.co/docs/deploy-manage/security/fips).
    </note>
  </definition>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.verification_mode">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Controls the verification of certificates.
    Defaults to `full`.
    **Valid values**:
    - `full`: Validates that the provided certificate: has an issue date that’s within the `not_before` and `not_after` dates; chains to a trusted Certificate Authority (CA); has a `hostname` or IP address that matches the names within the certificate.
    - `certificate`: Validates the provided certificate and verifies that it’s signed by a trusted authority (CA), but doesn’t check the certificate `hostname`.
    - `none`: Performs no certificate validation.
    <important>
      Setting certificate validation to `none` disables many security benefits of SSL/TLS, which is very dangerous. Only set this value if instructed by Elastic Support as a temporary diagnostic mechanism when attempting to resolve TLS errors.
    </important>
  </definition>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.cipher_suites">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Supported cipher suites vary depending on which version of Java you use. For example, for version 12 the default value is `TLS_AES_256_GCM_SHA384`, `TLS_AES_128_GCM_SHA256`, `TLS_CHACHA20_POLY1305_SHA256`, `TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384`, `TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256`, `TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384`, `TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256`, `TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256`, `TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256`, `TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384`, `TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256`, `TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384`, `TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256`, `TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA`, `TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA`, `TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA`, `TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA`, `TLS_RSA_WITH_AES_256_GCM_SHA384`, `TLS_RSA_WITH_AES_128_GCM_SHA256`, `TLS_RSA_WITH_AES_256_CBC_SHA256`, `TLS_RSA_WITH_AES_128_CBC_SHA256`, `TLS_RSA_WITH_AES_256_CBC_SHA`, `TLS_RSA_WITH_AES_128_CBC_SHA`.
    For more information, see Oracle’s [Java Cryptography Architecture documentation](https://docs.oracle.com/en/java/javase/11/security/oracle-providers.md#GUID-7093246A-31A3-4304-AC5F-5FB6400405E2).
  </definition>
</definitions>


### X-Pack monitoring TLS/SSL key and trusted certificate settings

The following settings are used to specify a private key, certificate, and the trusted certificates that should be used when communicating over an SSL/TLS connection. A private key and certificate are optional and would be used if the server requires client authentication for PKI authentication.

### PEM encoded files

When using PEM encoded files, use the following settings:
<definitions>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.key">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Path to a PEM encoded file containing the private key.
    If HTTP client authentication is required, it uses this file. You cannot use this setting and `ssl.keystore.path` at the same time.
  </definition>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.key_passphrase">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) The passphrase that is used to decrypt the private key. Since the key might not be encrypted, this value is optional
    <admonition title="Deprecated in 7.17.0">
      Prefer `ssl.secure_key_passphrase` instead.
    </admonition>
    You cannot use this setting and `ssl.secure_key_passphrase` at the same time.
  </definition>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.secure_key_passphrase">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Secure](https://www.elastic.co/docs/deploy-manage/security/secure-settings)) The passphrase that is used to decrypt the private key. Since the key might not be encrypted, this value is optional.
  </definition>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.certificate">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Specifies the path for the PEM encoded certificate (or certificate chain) that is associated with the key.
    This setting can be used only if `ssl.key` is set.
  </definition>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.certificate_authorities">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) List of paths to PEM encoded certificate files that should be trusted.
    This setting and `ssl.truststore.path` cannot be used at the same time.
  </definition>
</definitions>


### Java keystore files

When using Java keystore files (JKS), which contain the private key, certificate and certificates that should be trusted, use the following settings:
<definitions>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.keystore.path">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) The path for the keystore file that contains a private key and certificate.
    It must be either a Java keystore (jks) or a PKCS#12 file. You cannot use this setting and `ssl.key` at the same time.
  </definition>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.keystore.password">
    <admonition title="Deprecated in 7.17.0">
      Prefer `ssl.keystore.secure_password` instead.
    </admonition>
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) The password for the keystore.
  </definition>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.keystore.secure_password">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Secure](https://www.elastic.co/docs/deploy-manage/security/secure-settings)) The password for the keystore.
  </definition>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.keystore.key_password">
    <admonition title="Deprecated in 7.17.0">
      Prefer `ssl.keystore.secure_key_password` instead.
    </admonition>
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) The password for the key in the keystore. The default is the keystore password.
    You cannot use this setting and `ssl.keystore.secure_password` at the same time.
  </definition>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.keystore.secure_key_password">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Secure](https://www.elastic.co/docs/deploy-manage/security/secure-settings)) The password for the key in the keystore. The default is the keystore password.
  </definition>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.truststore.path">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) The path for the keystore that contains the certificates to trust. It must be either a Java keystore (jks) or a PKCS#12 file.
    You cannot use this setting and `ssl.certificate_authorities` at the same time.
  </definition>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.truststore.password">
    <admonition title="Deprecated in 7.17.0">
      Prefer `ssl.truststore.secure_password` instead.
    </admonition>
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) The password for the truststore.
    You cannot use this setting and `ssl.truststore.secure_password` at the same time.
  </definition>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.truststore.secure_password">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Secure](https://www.elastic.co/docs/deploy-manage/security/secure-settings)) Password for the truststore.
  </definition>
</definitions>


### PKCS#12 files

Elasticsearch can be configured to use PKCS#12 container files (`.p12` or `.pfx` files) that contain the private key, certificate and certificates that should be trusted.
PKCS#12 files are configured in the same way as Java keystore files:
<definitions>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.keystore.path">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) The path for the keystore file that contains a private key and certificate.
    It must be either a Java keystore (jks) or a PKCS#12 file. You cannot use this setting and `ssl.key` at the same time.
  </definition>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.keystore.type">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) The format of the keystore file. It must be either `jks` or `PKCS12`. If the keystore path ends in ".p12", ".pfx", or ".pkcs12", this setting defaults to `PKCS12`. Otherwise, it defaults to `jks`.
  </definition>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.keystore.password">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) The password for the keystore.
    <admonition title="Deprecated in 7.17.0">
      Prefer `ssl.keystore.secure_password` instead.
    </admonition>
  </definition>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.keystore.secure_password">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Secure](https://www.elastic.co/docs/deploy-manage/security/secure-settings)) The password for the keystore.
  </definition>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.keystore.key_password">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) The password for the key in the keystore. The default is the keystore password.
    <admonition title="Deprecated in 7.17.0">
      Prefer `ssl.keystore.secure_key_password` instead.
    </admonition>
    You cannot use this setting and `ssl.keystore.secure_password` at the same time.
  </definition>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.keystore.secure_key_password">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Secure](https://www.elastic.co/docs/deploy-manage/security/secure-settings)) The password for the key in the keystore. The default is the keystore password.
  </definition>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.truststore.path">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) The path for the keystore that contains the certificates to trust. It must be either a Java keystore (jks) or a PKCS#12 file.
    You cannot use this setting and `ssl.certificate_authorities` at the same time.
  </definition>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.truststore.type">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Set this to `PKCS12` to indicate that the truststore is a PKCS#12 file.
  </definition>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.truststore.password">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) The password for the truststore.
    <admonition title="Deprecated in 7.17.0">
      Prefer `ssl.truststore.secure_password` instead.
    </admonition>
    You cannot use this setting and `ssl.truststore.secure_password` at the same time.
  </definition>
  <definition term="xpack.monitoring.exporters.$NAME.ssl.truststore.secure_password">
    <admonition title="Deprecated in 7.16.0">
      This setting was deprecated in 7.16.0.
    </admonition>
    ([Secure](https://www.elastic.co/docs/deploy-manage/security/secure-settings)) Password for the truststore.
  </definition>
</definitions>