﻿---
title: Machine learning settings in Elasticsearch
description: You do not need to configure any settings to use machine learning. It is enabled by default. These settings are for advanced use cases; the default values...
url: https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/machine-learning-settings
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Machine learning settings in Elasticsearch
You do not need to configure any settings to use machine learning. It is enabled by default.
<important>
  Machine learning uses SSE4.2 instructions on x86_64 machines, so it works only on x86_64 machines whose CPUs [support](https://en.wikipedia.org/wiki/SSE4#Supporting_CPUs) SSE4.2. (This limitation does not apply to aarch64 machines.) If you run Elasticsearch on older x86_64 hardware, you must disable machine learning (by setting `xpack.ml.enabled` to `false`). In this situation you should not attempt to use machine learning functionality in your cluster at all.
</important>

<tip>
  To control memory usage used by machine learning jobs, you can use the [machine learning circuit breaker settings](/docs/reference/elasticsearch/configuration-reference/circuit-breaker-settings#circuit-breakers-page-model-inference).
</tip>


## General machine learning settings

<definitions>
  <definition term="node.roles: [ ml ]">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Set `node.roles` to contain `ml` to identify the node as a *machine learning node*. If you want to run machine learning jobs, there must be at least one machine learning node in your cluster.
    If you set `node.roles`, you must explicitly specify all the required roles for the node. To learn more, refer to [Node settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/node-settings).
    <important>
      - On dedicated coordinating nodes or dedicated master nodes, do not set the `ml` role.
      - It is strongly recommended that dedicated machine learning nodes also have the `remote_cluster_client` role; otherwise, cross-cluster search fails when used in machine learning jobs or datafeeds. See [Remote-eligible node](https://www.elastic.co/docs/deploy-manage/distributed-architecture/clusters-nodes-shards/node-roles#remote-node).
    </important>
  </definition>
  <definition term="xpack.ml.enabled">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) The default value (`true`) enables machine learning APIs on the node.
    <important>
      If you want to use machine learning features in your cluster, it is recommended that you use the default value for this setting on all nodes.
    </important>
    If set to `false`, the machine learning APIs are disabled on the node. For example, the node cannot open jobs, start datafeeds, receive transport (internal) communication requests, or requests from clients (including Kibana) related to machine learning APIs. If `xpack.ml.enabled` is not set uniformly across all nodes in your cluster then you are likely to experience problems with machine learning functionality not fully working.
    You must not use any machine learning functionality from ingest pipelines if `xpack.ml.enabled` is `false` on any node. Before setting `xpack.ml.enabled` to `false` on a node, consider whether you really meant to just exclude `ml` from the `node.roles`. Excluding `ml` from the [`node.roles`](/docs/reference/elasticsearch/configuration-reference/node-settings#node-roles) will stop the node from running machine learning jobs and NLP models, but it will still be aware that machine learning functionality exists. Setting `xpack.ml.enabled` to `false` should be reserved for situations where you cannot use machine learning functionality at all in your cluster due to hardware limitations as described [above](#ml-settings-description).
  </definition>
  <definition term="xpack.ml.inference_model.cache_size">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) The maximum inference cache size allowed. The inference cache exists in the JVM heap on each ingest node. The cache affords faster processing times for the `inference` processor. The value can be a static byte sized value (such as `2gb`) or a percentage of total allocated heap. Defaults to `40%`. See also [Machine learning circuit breaker](/docs/reference/elasticsearch/configuration-reference/circuit-breaker-settings#circuit-breakers-page-model-inference).
  </definition>
</definitions>


<definitions>
  <definition term="xpack.ml.inference_model.time_to_live logo cloud">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) The time to live (TTL) for trained models in the inference model cache. The TTL is calculated from last access. Users of the cache (such as the inference processor or inference aggregator) cache a model on its first use and reset the TTL on every use. If a cached model is not accessed for the duration of the TTL, it is flagged for eviction from the cache. If a document is processed later, the model is again loaded into the cache. To update this setting in Elasticsearch Service, see [Add Elasticsearch user settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference). Defaults to `5m`.
  </definition>
  <definition term="xpack.ml.max_inference_processors">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) The total number of `inference` type processors allowed across all ingest pipelines. Once the limit is reached, adding an `inference` processor to a pipeline is disallowed. Defaults to `50`.
  </definition>
  <definition term="xpack.ml.max_machine_memory_percent">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) The maximum percentage of the machine’s memory that machine learning may use for running analytics processes. These processes are separate to the Elasticsearch JVM. The limit is based on the total memory of the machine, not current free memory. Jobs are not allocated to a node if doing so would cause the estimated memory use of machine learning jobs to exceed the limit. When the operator privileges feature is enabled, this setting can be updated only by operator users. The minimum value is `5`; the maximum value is `200`. Defaults to `30`.
    <tip>
      Do not configure this setting to a value higher than the amount of memory left over after running the Elasticsearch JVM unless you have enough swap space to accommodate it and have determined this is an appropriate configuration for a specialist use case. The maximum setting value is for the special case where it has been determined that using swap space for machine learning jobs is acceptable. The general best practice is to not use swap on Elasticsearch nodes.
    </tip>
  </definition>
  <definition term="xpack.ml.max_model_memory_limit">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) The maximum `model_memory_limit` property value that can be set for any machine learning jobs in this cluster. If you try to create a job with a `model_memory_limit` property value that is greater than this setting value, an error occurs. Existing jobs are not affected when you update this setting. If this setting is `0` or unset, there is no maximum `model_memory_limit` value. If there are no nodes that meet the memory requirements for a job, this lack of a maximum memory limit means it’s possible to create jobs that cannot be assigned to any available nodes. For more information about the `model_memory_limit` property, see [Create anomaly detection jobs](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-put-job) or [Create data frame analytics jobs](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-put-data-frame-analytics). Defaults to `0` if `xpack.ml.use_auto_machine_memory_percent` is `false`. If `xpack.ml.use_auto_machine_memory_percent` is `true` and `xpack.ml.max_model_memory_limit` is not explicitly set then it will default to the largest `model_memory_limit` that could be assigned in the cluster.
  </definition>
</definitions>


<definitions>
  <definition term="xpack.ml.max_open_jobs">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) The maximum number of jobs that can run simultaneously on a node. In this context, jobs include both anomaly detection jobs and data frame analytics jobs. The maximum number of jobs is also constrained by memory usage. Thus if the estimated memory usage of the jobs would be higher than allowed, fewer jobs will run on a node. Prior to version 7.1, this setting was a per-node non-dynamic setting. It became a cluster-wide dynamic setting in version 7.1. As a result, changes to its value after node startup are used only after every node in the cluster is running version 7.1 or higher. The minimum value is `1`; the maximum value is `512`. Defaults to `512`.
    <note>
      This is a cluster-wide setting. If it is configured with different values across nodes, Elasticsearch resolves the inconsistency by applying the lowest configured value across the cluster as the effective cluster-wide limit.
    </note>
  </definition>
  <definition term="xpack.ml.nightly_maintenance_requests_per_second">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) The rate at which the nightly maintenance task deletes expired model snapshots and results. The setting is a proxy to the [`requests_per_second`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-delete-by-query) parameter used in the delete by query requests and controls throttling. When the operator privileges feature is enabled, this setting can be updated only by operator users. Valid values must be greater than `0.0` or equal to `-1.0`, where `-1.0` means a default value is used. Defaults to `-1.0`
  </definition>
  <definition term="xpack.ml.results_index_rollover_max_size">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) The maximum size the anomaly detection results indices can reach before being rolled over by the nightly maintenance task. When the operator privileges feature is enabled, this setting can be updated only by operator users. Valid values must be greater than or equal to `-1B`. A value of `-1B` means the indices will never be rolled over. A value of `0B` means the indices will always be rolled over, regardless of size. Defaults to `50GB`.
  </definition>
  <definition term="xpack.ml.node_concurrent_job_allocations">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) The maximum number of jobs that can concurrently be in the `opening` state on each node. Typically, jobs spend a small amount of time in this state before they move to `open` state. Jobs that must restore large models when they are opening spend more time in the `opening` state. When the operator privileges feature is enabled, this setting can be updated only by operator users. Defaults to `2`.
  </definition>
</definitions>


## Advanced machine learning settings

These settings are for advanced use cases; the default values are generally sufficient:
<definitions>
  <definition term="xpack.ml.enable_config_migration">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) Reserved. When the operator privileges feature is enabled, this setting can be updated only by operator users.
  </definition>
  <definition term="xpack.ml.max_anomaly_records">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) The maximum number of records that are output per bucket. Defaults to `500`.
  </definition>
  <definition term="xpack.ml.max_lazy_ml_nodes">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) The number of lazily spun up machine learning nodes. Useful in situations where machine learning nodes are not desired until the first machine learning job opens. If the current number of machine learning nodes is greater than or equal to this setting, it is assumed that there are no more lazy nodes available as the desired number of nodes have already been provisioned. If a job is opened and this setting has a value greater than zero and there are no nodes that can accept the job, the job stays in the `OPENING` state until a new machine learning node is added to the cluster and the job is assigned to run on that node. When the operator privileges feature is enabled, this setting can be updated only by operator users. Defaults to `0`.
    <important>
      This setting assumes some external process is capable of adding machine learning nodes to the cluster. This setting is only useful when used in conjunction with such an external process.
    </important>
  </definition>
  <definition term="xpack.ml.max_ml_node_size">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) The maximum node size for machine learning nodes in a deployment that supports automatic cluster scaling. If you set it to the maximum possible size of future machine learning nodes, when a machine learning job is assigned to a lazy node it can check (and fail quickly) when scaling cannot support the size of the job. When the operator privileges feature is enabled, this setting can be updated only by operator users. Defaults to `0b`, which means it will be assumed that automatic cluster scaling can add arbitrarily large nodes to the cluster.
  </definition>
</definitions>


<definitions>
  <definition term="xpack.ml.model_repository">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) The location of the machine learning model repository where the model artifact files are available in case of a model installation in a restricted or closed network. `xpack.ml.model_repository` can be a string of a file location or an HTTP/HTTPS server. Example values are:
    ```
    xpack.ml.model_repository: file://${path.home}/config/models/
    ```
    or
    ```
    xpack.ml.model_repository: <MY_CUSTOM_BACKEND_URL>
    ```
    If `xpack.ml.model_repository` is a file location, it must point to a subdirectory of the `config` directory of Elasticsearch.
  </definition>
  <definition term="xpack.ml.persist_results_max_retries">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) The maximum number of times to retry bulk indexing requests that fail while processing machine learning results. If the limit is reached, the machine learning job stops processing data and its status is `failed`. When the operator privileges feature is enabled, this setting can be updated only by operator users. The minimum value is `0`; the maximum value is `50`. Defaults to `20`.
  </definition>
  <definition term="xpack.ml.process_connect_timeout">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) The connection timeout for machine learning processes that run separately from the Elasticsearch JVM. When such processes are started they must connect to the Elasticsearch JVM. If the process does not connect within the time period specified by this setting then the process is assumed to have failed. When the operator privileges feature is enabled, this setting can be updated only by operator users. The minimum value is `5s`. Defaults to `10s`.
  </definition>
  <definition term="xpack.ml.use_auto_machine_memory_percent">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) If this setting is `true`, the `xpack.ml.max_machine_memory_percent` setting is ignored. Instead, the maximum percentage of the machine’s memory that can be used for running machine learning analytics processes is calculated automatically and takes into account the total node size and the size of the JVM on the node. When the operator privileges feature is enabled, this setting can be updated only by operator users. The default value is `false`.
    <important>
      - If you do not have dedicated machine learning nodes (that is to say, the node has multiple roles), do not enable this setting. Its calculations assume that machine learning analytics are the main purpose of the node.
      - The calculation assumes that dedicated machine learning nodes have at least `256MB` memory reserved outside of the JVM. If you have tiny machine learning nodes in your cluster, you shouldn’t use this setting.
    </important>
    If this setting is `true` it also affects the default value for `xpack.ml.max_model_memory_limit`. In this case `xpack.ml.max_model_memory_limit` defaults to the largest size that could be assigned in the current cluster.
  </definition>
</definitions>