﻿---
title: Local gateway
description: The local gateway stores the cluster state and shard data across full cluster restarts. The following static settings, which must be set on every master-eligible...
url: https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/local-gateway
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Local gateway
The local gateway stores the cluster state and shard data across full cluster restarts.
The following *static* settings, which must be set on every [master-eligible node](https://www.elastic.co/docs/deploy-manage/distributed-architecture/clusters-nodes-shards/node-roles#master-node-role), control how long a freshly elected master should wait before it tries to recover the [cluster state](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-state) and the cluster’s data.
<note>
  These settings only take effect during a [full cluster restart](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/full-cluster-restart-rolling-restart-procedures#restart-cluster-full).
</note>

<definitions>
  <definition term="gateway.expected_data_nodes">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Number of data nodes expected in the cluster. Recovery of local shards begins when the expected number of data nodes join the cluster. Defaults to `0`.
  </definition>
  <definition term="gateway.recover_after_time">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) If the expected number of nodes is not achieved, the recovery process waits for the configured amount of time before trying to recover. Defaults to `5m`.
    Once the `recover_after_time` duration has timed out, recovery will start as long as the following condition is met:
  </definition>
  <definition term="gateway.recover_after_data_nodes">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Recover as long as this many data nodes have joined the cluster.
  </definition>
</definitions>

These settings can be configured in `elasticsearch.yml` as follows:
```yaml
gateway.expected_data_nodes: 3
gateway.recover_after_time: 600s
gateway.recover_after_data_nodes: 3
```