﻿---
title: Index lifecycle management settings in Elasticsearch
description: These are the settings available for configuring index lifecycle management (ILM). These index-level ILM settings are typically configured through index...
url: https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/index-lifecycle-management-settings
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Index lifecycle management settings in Elasticsearch
These are the settings available for configuring [index lifecycle management](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management) (ILM).

## Cluster level settings

<definitions>
  <definition term="xpack.ilm.enabled">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting), Boolean)
    <admonition title="Deprecated in 7.8.0">
      This deprecated setting has no effect and will be removed in Elasticsearch 8.0.
    </admonition>
  </definition>
  <definition term="indices.lifecycle.history_index_enabled">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting), Boolean) Whether ILM’s history index is enabled. If enabled, ILM will record the history of actions taken as part of ILM policies to the `ilm-history-*` indices. Defaults to `true`.
  </definition>
</definitions>


<definitions>
  <definition term="indices.lifecycle.poll_interval">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting), [time unit value](/docs/reference/elasticsearch/rest-apis/api-conventions#time-units)) How often index lifecycle management checks for indices that meet policy criteria. Defaults to `10m`.
  </definition>
</definitions>


<definitions>
  <definition term="indices.lifecycle.rollover.only_if_has_documents">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting), Boolean) Whether ILM will only roll over non-empty indices. If enabled, ILM will only roll over indices as long as they contain at least one document. Defaults to `true`.
  </definition>
</definitions>


## Index level settings

<admonition title="Settings supported in Serverless">
  Elastic Cloud Serverless projects [restrict the available Elasticsearch settings](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/differences-from-other-elasticsearch-offerings#elasticsearch-differences-serverless-settings-availability) to a supported subset, identified with a `Serverless` badge next to the setting name. For a complete list of available index settings, refer to the [Serverless index settings list](https://www.elastic.co/docs/reference/elasticsearch/index-settings/serverless).
</admonition>

These index-level ILM settings are typically configured through index templates. For more information, see [Create a lifecycle policy](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/ilm-tutorials#ilm-gs-create-policy).
<definitions>
  <definition term="index.lifecycle.indexing_complete">
    ([Dynamic](/docs/reference/elasticsearch/index-settings#index-modules-settings-description), Boolean) Indicates whether or not the index has been rolled over. Automatically set to `true` when ILM completes the rollover action. You can explicitly set it to [skip rollover](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/skip-rollover). Defaults to `false`.
  </definition>
</definitions>


<definitions>
  <definition term="index.lifecycle.name">
    ([Dynamic](/docs/reference/elasticsearch/index-settings#index-modules-settings-description), string) The name of the policy to use to manage the index. For information about how Elasticsearch applies policy changes, see [Policy updates](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/policy-updates). If you are restoring an index from snapshot that was previously managed by index lifecycle management, you can override this setting to null during the restore operation to disable further management of the index. See also [Index level settings](#index-lifecycle-rollover-alias).
  </definition>
</definitions>


<definitions>
  <definition term="index.lifecycle.origination_date Elastic Cloud Serverless: Generally available">
    ([Dynamic](/docs/reference/elasticsearch/index-settings#index-modules-settings-description), long) If specified, this is the timestamp used to calculate the index age for its phase transitions. Use this setting if you create a new index that contains old data and want to use the original creation date to calculate the index age. Specified as a Unix epoch value in milliseconds.
  </definition>
</definitions>


<definitions>
  <definition term="index.lifecycle.parse_origination_date">
    ([Dynamic](/docs/reference/elasticsearch/index-settings#index-modules-settings-description), Boolean) Set to `true` to parse the origination date from the index name. This origination date is used to calculate the index age for its phase transitions. The index name must match the pattern `^.*-{{date_format}}-\\d+`, where the `date_format` is `yyyy.MM.dd` and the trailing digits are optional. An index that was rolled over would normally match the full format, for example `logs-2016.10.31-000002`). If the index name doesn’t match the pattern, index creation fails.
  </definition>
</definitions>


<definitions>
  <definition term="index.lifecycle.step.wait_time_threshold">
    ([Dynamic](/docs/reference/elasticsearch/index-settings#index-modules-settings-description), [time value](/docs/reference/elasticsearch/rest-apis/api-conventions#time-units)) Time to wait for the cluster to resolve allocation issues during an ILM [`shrink`](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-shrink) action. Must be greater than `1h` (1 hour). Defaults to `12h` (12 hours). See [Shard allocation for shrink](/docs/reference/elasticsearch/index-lifecycle-actions/ilm-shrink#ilm-shrink-shard-allocation).
  </definition>
</definitions>


<definitions>
  <definition term="index.lifecycle.rollover_alias">
    ([Dynamic](/docs/reference/elasticsearch/index-settings#index-modules-settings-description), string) The index alias to update when the index rolls over. Specify when using a policy that contains a rollover action. When the index rolls over, the alias is updated to reflect that the index is no longer the write index. For more information about rolling indices, see [Rollover](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/rollover). If you are restoring an index from snapshot that was previously managed by index lifecycle management, you can override this setting to null during the restore operation to disable further management of future indices. See also [Index level settings](#index-lifecycle-name).
  </definition>
</definitions>