﻿---
title: Health diagnostic settings in Elasticsearch
description: The following are the expert-level settings available for configuring an internal diagnostics service. The output of this service is currently exposed...
url: https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/health-diagnostic-settings
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Health diagnostic settings in Elasticsearch
The following are the *expert-level* settings available for configuring an internal diagnostics service. The output of this service is currently exposed through the Health API [Health API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-health-report). It is not recommended to change any of these from their default values.

## Cluster level settings

<definitions>
  <definition term="health.master_history.has_master_lookup_timeframe">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) The amount of time a node looks back to see if it has observed a master at all, before moving on with other checks. Defaults to `30s` (30 seconds).
  </definition>
  <definition term="master_history.max_age">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) The timeframe we record the master history to be used for diagnosing the cluster health. Master node changes older than this time will not be considered when diagnosing the cluster health. Defaults to `30m` (30 minutes).
  </definition>
  <definition term="health.master_history.identity_changes_threshold">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) The number of master identity changes witnessed by a node that indicates the cluster is not healthy. Defaults to `4`.
  </definition>
  <definition term="health.master_history.no_master_transitions_threshold">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) The number of transitions to no master witnessed by a node that indicates the cluster is not healthy. Defaults to `4`.
  </definition>
  <definition term="health.node.enabled">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) Enables the health node, which allows the health API to provide indications about cluster wide health aspects such as disk space.
  </definition>
  <definition term="health.reporting.local.monitor.interval">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) Determines the interval in which each node of the cluster monitors aspects that comprise its local health such as its disk usage.
  </definition>
  <definition term="health.ilm.max_time_on_action">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) The minimum amount of time an index has to be in an index lifecycle management (ILM) action before it is considered stagnant. Defaults to `1d` (1 day).
  </definition>
  <definition term="health.ilm.max_time_on_step">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) The minimum amount of time an index has to be in an ILM step before it is considered stagnant. Defaults to `1d` (1 day).
  </definition>
  <definition term="health.ilm.max_retries_per_step">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) The minimum amount of times an index has retried by an ILM step before it is considered stagnant. Defaults to `100`
  </definition>
  <definition term="health.periodic_logger.enabled">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) Enables the health periodic logger, which logs the health statuses of each health indicator along with the top level one as observed by the Health API. Defaults to `false`.
  </definition>
  <definition term="health.periodic_logger.poll_interval">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting), [time unit value](/docs/reference/elasticsearch/rest-apis/api-conventions#time-units)) How often Elasticsearch logs the health status of the cluster and of each health indicator as observed by the Health API. Defaults to `60s` (60 seconds).
  </definition>
  <definition term="health.shard_capacity.unhealthy_threshold.yellow Elastic Stack: Generally available since 9.3">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) The minimum number of additional shards the cluster must still be able to allocate (on data or frozen nodes) for shard capacity health to remain `GREEN`. If fewer are available, health becomes `YELLOW`. Must be greater than `health.shard_capacity.unhealthy_threshold.red`. Defaults to `10`.
  </definition>
  <definition term="health.shard_capacity.unhealthy_threshold.red Elastic Stack: Generally available since 9.3">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) The minimum number of additional shards the cluster must still be able to allocate (on data or frozen nodes) below which shard capacity health becomes `RED`. Must be less than `health.shard_capacity.unhealthy_threshold.yellow`. Defaults to `5`.
  </definition>
</definitions>