﻿---
title: Enrich settings
description: You can configure these enrich settings in the elasticsearch.yml file. For more information, see Set up an enrich processor. 
url: https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/enrich-settings
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Enrich settings
You can configure these enrich settings in the `elasticsearch.yml` file. For more information, see [Set up an enrich processor](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/set-up-an-enrich-processor).
<definitions>
  <definition term="enrich.cache_size logo cloud">
    Maximum number of searches to cache for enriching documents. Defaults to 1000. There is a single cache for all enrich processors in the cluster. This setting determines the size of that cache.
  </definition>
  <definition term="enrich.coordinator_proxy.max_concurrent_requests logo cloud">
    Maximum number of concurrent multi-search requests to run when enriching documents. Defaults to 8.
  </definition>
  <definition term="enrich.coordinator_proxy.max_lookups_per_request logo cloud">
    Maximum number of searches to include in a multi-search request when enriching documents. Defaults to 128.
  </definition>
  <definition term="enrich.coordinator_proxy.queue_capacity logo cloud">
    coordinator queue capacity, defaults to max_concurrent_requests * max_lookups_per_request
  </definition>
</definitions>