﻿---
title: Discovery and cluster formation settings
description: Discovery and cluster formation are affected by the following settings: Discovery and cluster formation are also affected by the following expert-level...
url: https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/discovery-cluster-formation-settings
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Discovery and cluster formation settings
[Discovery and cluster formation](https://www.elastic.co/docs/deploy-manage/distributed-architecture/discovery-cluster-formation) are affected by the following settings:
<definitions>
  <definition term="discovery.seed_hosts">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Provides a list of the addresses of the master-eligible nodes in the cluster. May also be a single string containing the addresses separated by commas. Each address has the format `host:port` or `host`. The `host` is either a host name to be resolved by DNS, an IPv4 address, or an IPv6 address. IPv6 addresses must be enclosed in square brackets. If a host name resolves via DNS to multiple addresses, Elasticsearch uses all of them. DNS lookups are subject to [JVM DNS caching](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/important-settings-configuration). If the `port` is not given then it is determined by checking the following settings in order:
    1. `transport.profiles.default.port`
    2. `transport.port`
    If neither of these is set then the default port is `9300`. The default value for `discovery.seed_hosts` is `["127.0.0.1", "[::1]"]`. See [`discovery.seed_hosts`](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/important-settings-configuration#unicast.hosts).
  </definition>
  <definition term="discovery.seed_providers">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Specifies which types of [seed hosts provider](https://www.elastic.co/docs/deploy-manage/distributed-architecture/discovery-cluster-formation/discovery-hosts-providers#built-in-hosts-providers) to use to obtain the addresses of the seed nodes used to start the discovery process. By default, it is the [settings-based seed hosts provider](https://www.elastic.co/docs/deploy-manage/distributed-architecture/discovery-cluster-formation/discovery-hosts-providers#settings-based-hosts-provider) which obtains the seed node addresses from the `discovery.seed_hosts` setting.
  </definition>
  <definition term="discovery.type">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Specifies whether Elasticsearch should form a multiple-node cluster. Defaults to `multi-node`, which means that Elasticsearch discovers other nodes when forming a cluster and allows other nodes to join the cluster later. If set to `single-node`, Elasticsearch forms a single-node cluster and suppresses the timeout set by `cluster.publish.timeout`. For more information about when you might use this setting, see [Single-node discovery](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/bootstrap-checks#single-node-discovery).
  </definition>
  <definition term="cluster.initial_master_nodes">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Sets the initial set of master-eligible nodes in a brand-new cluster. By default this list is empty, meaning that this node expects to join a cluster that has already been bootstrapped. Remove this setting once the cluster has formed, and never set it again for this cluster. Do not configure this setting on master-ineligible nodes. Do not configure this setting on nodes joining an existing cluster. Do not configure this setting on nodes which are restarting. Do not configure this setting when performing a full-cluster restart. See [`cluster.initial_master_nodes`](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/important-settings-configuration#initial_master_nodes).
  </definition>
</definitions>


## Expert settings

Discovery and cluster formation are also affected by the following *expert-level* settings, although it is not recommended to change any of these from their default values.
<warning>
  If you adjust these settings then your cluster may not form correctly or may become unstable or intolerant of certain failures.
</warning>

<definitions>
  <definition term="discovery.cluster_formation_warning_timeout">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Sets how long a node will try to form a cluster before logging a warning that the cluster did not form. Defaults to `10s`. If a cluster has not formed after `discovery.cluster_formation_warning_timeout` has elapsed then the node will log a warning message that starts with the phrase `master not discovered` which describes the current state of the discovery process.
  </definition>
  <definition term="discovery.find_peers_interval">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Sets how long a node will wait before attempting another discovery round. Defaults to `1s`.
  </definition>
  <definition term="discovery.probe.connect_timeout">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Sets how long to wait when attempting to connect to each address. Defaults to `30s`.
  </definition>
  <definition term="discovery.probe.handshake_timeout">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Sets how long to wait when attempting to identify the remote node via a handshake. Defaults to `30s`.
  </definition>
  <definition term="discovery.request_peers_timeout">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) In 9.1.x and earlier versions, sets how long a node will wait after asking its peers again before considering the request to have failed. Has no effect from version 9.2.0 onwards. Defaults to `3s`.
  </definition>
  <definition term="discovery.find_peers_warning_timeout">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Sets how long a node will attempt to discover its peers before it starts to log verbose messages describing why the connection attempts are failing. Defaults to `3m`.
  </definition>
  <definition term="discovery.seed_resolver.max_concurrent_resolvers">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Specifies how many concurrent DNS lookups to perform when resolving the addresses of seed nodes. Defaults to `10`.
  </definition>
  <definition term="discovery.seed_resolver.timeout">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Specifies how long to wait for each DNS lookup performed when resolving the addresses of seed nodes. Defaults to `5s`.
  </definition>
  <definition term="cluster.auto_shrink_voting_configuration">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) Controls whether the [voting configuration](https://www.elastic.co/docs/deploy-manage/distributed-architecture/discovery-cluster-formation/modules-discovery-voting) sheds departed nodes automatically, as long as it still contains at least 3 nodes. The default value is `true`. If set to `false`, the voting configuration never shrinks automatically and you must remove departed nodes manually with the [voting configuration exclusions API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-post-voting-config-exclusions).
  </definition>
  <definition term="cluster.election.back_off_time">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Sets the amount to increase the upper bound on the wait before an election on each election failure. Note that this is *linear* backoff. This defaults to `100ms`. Changing this setting from the default may cause your cluster to fail to elect a master node.
  </definition>
  <definition term="cluster.election.duration">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Sets how long each election is allowed to take before a node considers it to have failed and schedules a retry. This defaults to `500ms`. Changing this setting from the default may cause your cluster to fail to elect a master node.
  </definition>
  <definition term="cluster.election.initial_timeout">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Sets the upper bound on how long a node will wait initially, or after the elected master fails, before attempting its first election. This defaults to `100ms`. Changing this setting from the default may cause your cluster to fail to elect a master node.
  </definition>
  <definition term="cluster.election.max_timeout">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Sets the maximum upper bound on how long a node will wait before attempting an first election, so that an network partition that lasts for a long time does not result in excessively sparse elections. This defaults to `10s`. Changing this setting from the default may cause your cluster to fail to elect a master node.
  </definition>
  <definition term="cluster.fault_detection.follower_check.interval">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Sets how long the elected master waits between follower checks to each other node in the cluster. Defaults to `1s`. Changing this setting from the default may cause your cluster to become unstable.
  </definition>
  <definition term="cluster.fault_detection.follower_check.timeout">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Sets how long the elected master waits for a response to a follower check before considering it to have failed. Defaults to `10s`. Changing this setting from the default may cause your cluster to become unstable.
  </definition>
  <definition term="cluster.fault_detection.follower_check.retry_count">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Sets how many consecutive follower check failures must occur to each node before the elected master considers that node to be faulty and removes it from the cluster. Defaults to `3`. Changing this setting from the default may cause your cluster to become unstable.
  </definition>
  <definition term="cluster.fault_detection.leader_check.interval">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Sets how long each node waits between checks of the elected master. Defaults to `1s`. Changing this setting from the default may cause your cluster to become unstable.
  </definition>
  <definition term="cluster.fault_detection.leader_check.timeout">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Sets how long each node waits for a response to a leader check from the elected master before considering it to have failed. Defaults to `10s`. Changing this setting from the default may cause your cluster to become unstable.
  </definition>
  <definition term="cluster.fault_detection.leader_check.retry_count">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Sets how many consecutive leader check failures must occur before a node considers the elected master to be faulty and attempts to find or elect a new master. Defaults to `3`. Changing this setting from the default may cause your cluster to become unstable.
  </definition>
  <definition term="cluster.follower_lag.timeout">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Sets how long the master node waits to receive acknowledgements for cluster state updates from lagging nodes. The default value is `90s`. If a node does not successfully apply the cluster state update within this period of time, it is considered to have failed and is removed from the cluster. See [Publishing the cluster state](https://www.elastic.co/docs/deploy-manage/distributed-architecture/discovery-cluster-formation/cluster-state-overview#cluster-state-publishing).
    <applies-to>Elastic Stack: Planned</applies-to> The value `-1` means that the master node will wait indefinitely for cluster state updates to be acknowledged.
  </definition>
  <definition term="cluster.max_voting_config_exclusions">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) Sets a limit on the number of voting configuration exclusions at any one time. The default value is `10`. See [*Add and remove nodes in your cluster*](https://www.elastic.co/docs/deploy-manage/maintenance/add-and-remove-elasticsearch-nodes).
  </definition>
  <definition term="cluster.publish.info_timeout">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Sets how long the master node waits for each cluster state update to be completely published to all nodes before logging a message indicating that some nodes are responding slowly. The default value is `10s`.
  </definition>
  <definition term="cluster.publish.timeout">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Sets how long the master node waits for each cluster state update to be completely published to all nodes, unless `discovery.type` is set to `single-node`. The default value is `30s`. See [Publishing the cluster state](https://www.elastic.co/docs/deploy-manage/distributed-architecture/discovery-cluster-formation/cluster-state-overview#cluster-state-publishing).
  </definition>
  <definition term="cluster.discovery_configuration_check.interval">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Sets the interval of some checks that will log warnings about an incorrect discovery configuration. The default value is `30s`.
  </definition>
  <definition term="cluster.join_validation.cache_timeout">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) When a node requests to join the cluster, the elected master node sends it a copy of a recent cluster state to detect certain problems which might prevent the new node from joining the cluster. The master caches the state it sends and uses the cached state if another node joins the cluster soon after. This setting controls how long the master waits until it clears this cache. Defaults to `60s`.
  </definition>
</definitions>


<definitions>
  <definition term="cluster.no_master_block">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) Specifies which operations are rejected when there is no active master in a cluster. This setting has three valid values:
    <definitions>
      <definition term="all">
        All operations on the node (both read and write operations) are rejected. This also applies for API cluster state read or write operations, like the get index settings, update mapping, and cluster state API.
      </definition>
      <definition term="write">
        (default) Write operations are rejected. Read operations succeed, based on the last known cluster configuration. This situation may result in partial reads of stale data as this node may be isolated from the rest of the cluster.
      </definition>
      <definition term="metadata_write">
        Only metadata write operations (e.g. mapping updates, routing table changes) are rejected but regular indexing operations continue to work. Read and write operations succeed, based on the last known cluster configuration. This situation may result in partial reads of stale data as this node may be isolated from the rest of the cluster.
      </definition>
    </definitions>
    <note>
      - The `cluster.no_master_block` setting doesn’t apply to nodes-based APIs (for example, cluster stats, node info, and node stats APIs). Requests to these APIs are not be blocked and can run on any available node.
      - For the cluster to be fully operational, it must have an active master.
    </note>
  </definition>
  <definition term="monitor.fs.health.enabled">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) If `true`, the node runs periodic [filesystem health checks](https://www.elastic.co/docs/deploy-manage/distributed-architecture/discovery-cluster-formation/cluster-fault-detection#cluster-fault-detection-filesystem-health). Defaults to `true`.
  </definition>
  <definition term="monitor.fs.health.refresh_interval">
    ([Static](https://www.elastic.co/docs/deploy-manage/stack-settings#static-cluster-setting)) Interval between successive [filesystem health checks](https://www.elastic.co/docs/deploy-manage/distributed-architecture/discovery-cluster-formation/cluster-fault-detection#cluster-fault-detection-filesystem-health). Defaults to `2m`.
  </definition>
  <definition term="monitor.fs.health.slow_path_logging_threshold">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) If a [filesystem health checks](https://www.elastic.co/docs/deploy-manage/distributed-architecture/discovery-cluster-formation/cluster-fault-detection#cluster-fault-detection-filesystem-health) takes longer than this threshold then Elasticsearch logs a warning. Defaults to `5s`.
  </definition>
</definitions>