﻿---
title: Data stream lifecycle settings in Elasticsearch
description: These are the settings available for configuring data stream lifecycle. The following index-level settings are typically configured on the backing indices...
url: https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/data-stream-lifecycle-settings
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Data stream lifecycle settings in Elasticsearch
These are the settings available for configuring [data stream lifecycle](https://www.elastic.co/docs/manage-data/lifecycle/data-stream).

## Cluster level settings


<definitions>
  <definition term="data_streams.lifecycle.retention.max">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting), [time unit value](/docs/reference/elasticsearch/rest-apis/api-conventions#time-units)) The maximum retention period that will apply to all user data streams managed by the data stream lifecycle. The max retention will also override the retention of a data stream whose configured retention exceeds the max retention. It should be greater than `10s`.
  </definition>
</definitions>


<definitions>
  <definition term="data_streams.lifecycle.retention.default">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting), [time unit value](/docs/reference/elasticsearch/rest-apis/api-conventions#time-units)) The retention period that will apply to all user data streams managed by the data stream lifecycle that do not have retention configured. It should be greater than `10s` and less or equals than [`data_streams.lifecycle.retention.max`](#data-streams-lifecycle-retention-max).
  </definition>
</definitions>


<definitions>
  <definition term="data_streams.lifecycle.poll_interval">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting), [time unit value](/docs/reference/elasticsearch/rest-apis/api-conventions#time-units)) How often Elasticsearch checks what is the next action for all data streams with a built-in lifecycle. Defaults to `5m`.
  </definition>
</definitions>


<definitions>
  <definition term="cluster.lifecycle.default.rollover">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting), string) This property accepts a key value pair formatted string and configures the conditions that would trigger a data stream to [rollover](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/rollover) when it has `lifecycle` configured. This property is an implementation detail and subject to change. Currently, it defaults to `max_age=auto,max_primary_shard_size=50gb,min_docs=1,max_primary_shard_docs=200000000`, this means that your data stream will rollover if any of the following conditions are met:
    - Either any primary shard reaches the size of 50GB,
    - or any primary shard contains 200.000.000 documents
    - or the index reaches a certain age which depends on the retention time of your data stream,
    - **and** has at least one document.
  </definition>
</definitions>


<definitions>
  <definition term="data_streams.lifecycle.target.merge.policy.merge_factor">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting), integer) Data stream lifecycle implements [tail merging](https://www.elastic.co/docs/manage-data/lifecycle/data-stream#data-streams-lifecycle-how-it-works) by updating the lucene merge policy factor for the target backing index. The merge factor is both the number of segments that should be merged together, and the maximum number of segments that we expect to find on a given tier. This setting controls what value does [Data stream lifecycle](https://www.elastic.co/docs/manage-data/lifecycle/data-stream) configures on the target index. It defaults to `16`. The value will be visible under the `index.merge.policy.merge_factor` index setting on the target index.
  </definition>
</definitions>


<definitions>
  <definition term="data_streams.lifecycle.target.merge.policy.floor_segment">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) Data stream lifecycle implements [tail merging](https://www.elastic.co/docs/manage-data/lifecycle/data-stream#data-streams-lifecycle-how-it-works) by updating the lucene merge policy floor segment for the target backing index. This floor segment size is a way to prevent indices from having a long tail of very small segments. This setting controls what value does [data stream lifecycle](https://www.elastic.co/docs/manage-data/lifecycle/data-stream) configures on the target index. It defaults to `100MB`.
  </definition>
</definitions>


<definitions>
  <definition term="data_streams.lifecycle.signalling.error_retry_interval">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting), integer) Represents the number of retries data stream lifecycle has to perform for an index in an error step in order to signal that the index is not progressing (i.e. it’s stuck in an error step). The current signalling mechanism is a log statement at the `error` level however, the signalling mechanism can be extended in the future. Defaults to 10 retries.
  </definition>
</definitions>


## Index level settings

<admonition title="Settings supported in Serverless">
  Elastic Cloud Serverless projects [restrict the available Elasticsearch settings](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/differences-from-other-elasticsearch-offerings#elasticsearch-differences-serverless-settings-availability) to a supported subset, identified with a `Serverless` badge next to the setting name. For a complete list of available index settings, refer to the [Serverless index settings list](https://www.elastic.co/docs/reference/elasticsearch/index-settings/serverless).
</admonition>

The following index-level settings are typically configured on the backing indices of a data stream.

<definitions>
  <definition term="index.lifecycle.prefer_ilm">
    ([Dynamic](/docs/reference/elasticsearch/index-settings#index-modules-settings-description), boolean) This setting determines which feature is managing the backing index of a data stream if, and only if, the backing index has an [index lifecycle management](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management) (ILM) policy and the data stream has also a built-in lifecycle. When `true` this index is managed by ILM, when `false` the backing index is managed by the data stream lifecycle. Defaults to `true`.
  </definition>
</definitions>


<definitions>
  <definition term="index.lifecycle.origination_date Elastic Cloud Serverless: Generally available">
    ([Dynamic](/docs/reference/elasticsearch/index-settings#index-modules-settings-description), long) If specified, this is the timestamp used to calculate the backing index generation age after this backing index has been [rolled over](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/rollover). The generation age is used to determine data retention, consequently, you can use this setting if you create a backing index that contains older data and want to ensure that the retention period or other parts of the lifecycle will be applied based on the data’s original timestamp and not the timestamp they got indexed. Specified as a Unix epoch value in milliseconds.
  </definition>
</definitions>


## Reindex settings

You can use the following cluster-level settings to control the behavior of the reindex data stream API:
`migrate.max_concurrent_indices_reindexed_per_data_stream` ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) The number of backing indices within a given data stream which will be reindexed concurrently. Defaults to `1`.
`migrate.data_stream_reindex_max_request_per_second` ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) The average maximum number of documents within a given backing index to reindex per second. Defaults to `1000`, though can be any decimal number greater than `0`. To remove throttling, set to `-1`. This setting can be used to throttle the reindex process and manage resource usage. Consult the [reindex throttle docs](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-reindex#docs-reindex-throttle) for more information.