﻿---
title: Elasticsearch configuration reference
description: Configuration settings enable you to customize the behavior of Elasticsearch features. This reference provides details about each setting, such as its...
url: https://www.elastic.co/docs/reference/elasticsearch/configuration-reference
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Elasticsearch configuration reference
Configuration settings enable you to customize the behavior of Elasticsearch features.
This reference provides details about each setting, such as its purpose, default behavior, and availability in various deployment contexts.
To learn how to update these settings on your cluster, including on ECH, ECE, ECK, and self-managed deployments, refer to [Elastic Stack settings](https://www.elastic.co/docs/deploy-manage/stack-settings).
This section provides detailed **reference information** for Elasticsearch configuration. Refer to the [Deploy and manage](https://www.elastic.co/docs/deploy-manage) section to get started with deploying and configuring Elasticsearch, and to learn when and how to use some of these settings.
<admonition title="Serverless manages these settings for you">
  In Elastic Cloud Serverless, cluster-level settings and node-level settings are not required by end users, and are fully managed by Elastic.Certain [project settings](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings) allow you to customize your project’s performance and general data retention, and enable or disable project features.
</admonition>

For information about index-level settings, refer to [Index settings](https://www.elastic.co/docs/reference/elasticsearch/index-settings).
The settings are grouped by feature or purpose, for example:
- [Auditing](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/auding-settings)
- [Circuit breaker](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/circuit-breaker-settings)
- [Cluster formation and discovery](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/discovery-cluster-formation-settings)
- [Cross-cluster replication](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/cross-cluster-replication-settings)
- [Data stream lifecycle](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/data-stream-lifecycle-settings)
- [Enrich settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/enrich-settings)
- [Field data cache](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/field-data-cache-settings)
- [Health diagnostic](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/health-diagnostic-settings)
- [Index lifecycle management](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/index-lifecycle-management-settings),
- [Index management](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/index-management-settings)
- [Index recovery](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/index-recovery-settings)
- [Index buffer](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/indexing-buffer-settings)
- [Inference](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/inference-settings)
- [License](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/license-settings)
- [Local gateway](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/local-gateway)
- [Machine learning](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/machine-learning-settings)
- [Monitoring](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/monitoring-settings)
- [Networking](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings)
- [Nodes](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/node-settings)
- [Node query cache](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/node-query-cache-settings)
- [Remote clusters](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/remote-clusters)
- [Search](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/search-settings)
- [Security](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings)
- [Shard request cache](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/shard-request-cache-settings)
- [Shard routing](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/cluster-level-shard-allocation-routing-settings)
- [Snapshot and restore](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/snapshot-restore-settings)
- [Transforms](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/transforms-settings)
- [Thread pools](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/thread-pool-settings)
- [Watcher](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/watcher-settings)