﻿---
title: elasticsearch-syskeygen
description: The elasticsearch-syskeygen command creates a system key file in the elasticsearch config directory. The command generates a system_key file, which you...
url: https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/syskeygen
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# elasticsearch-syskeygen
The `elasticsearch-syskeygen` command creates a system key file in the elasticsearch config directory.

## Synopsis

```shell
bin/elasticsearch-syskeygen
[-E <KeyValuePair>] [-h, --help]
([-s, --silent] | [-v, --verbose])
```


## Description

The command generates a `system_key` file, which you can use to symmetrically encrypt sensitive data. For example, you can use this key to prevent Watcher from returning and storing information that contains clear text credentials. See [*Encrypting sensitive data in Watcher*](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/encrypting-data).
<important>
  The system key is a symmetric key, so the same key must be used on every node in the cluster.
</important>


## Parameters

<definitions>
  <definition term="-E <KeyValuePair>">
    Configures a setting. For example, if you have a custom installation of Elasticsearch, you can use this parameter to specify the `ES_PATH_CONF` environment variable.
  </definition>
  <definition term="-h, --help">
    Returns all of the command parameters.
  </definition>
  <definition term="-s, --silent">
    Shows minimal output.
  </definition>
  <definition term="-v, --verbose">
    Shows verbose output.
  </definition>
</definitions>


## Examples

The following command generates a `system_key` file in the default `$ES_HOME/config` directory:
```sh
bin/elasticsearch-syskeygen
```