﻿---
title: elasticsearch-saml-metadata
description: The elasticsearch-saml-metadata command can be used to generate a SAML 2.0 Service Provider Metadata file. The SAML 2.0 specification provides a mechanism...
url: https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/saml-metadata
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# elasticsearch-saml-metadata
The `elasticsearch-saml-metadata` command can be used to generate a SAML 2.0 Service Provider Metadata file.

## Synopsis

```shell
bin/elasticsearch-saml-metadata
[--realm <name>]
[--out <file_path>] [--batch]
[--attribute <name>] [--service-name <name>]
[--locale <name>] [--contacts]
([--organisation-name <name>] [--organisation-display-name <name>] [--organisation-url <url>])
([--signing-bundle <file_path>] | [--signing-cert <file_path>][--signing-key <file_path>])
[--signing-key-password <password>]
[-E <KeyValuePair>]
[-h, --help] ([-s, --silent] | [-v, --verbose])
```


## Description

The SAML 2.0 specification provides a mechanism for Service Providers to describe their capabilities and configuration using a *metadata file*.
The `elasticsearch-saml-metadata` command generates such a file, based on the configuration of a SAML realm in Elasticsearch.
Some SAML Identity Providers will allow you to automatically import a metadata file when you configure the Elastic Stack as a Service Provider.
You can optionally select to digitally sign the metadata file in order to ensure its integrity and authenticity before sharing it with the Identity Provider. The key used for signing the metadata file need not necessarily be the same as the keys already used in the saml realm configuration for SAML message signing.
If your Elasticsearch keystore is password protected, you are prompted to enter the password when you run the `elasticsearch-saml-metadata` command.

## Parameters

<definitions>
  <definition term="--attribute <name>">
    Specifies a SAML attribute that should be included as a `<RequestedAttribute>` element in the metadata. Any attribute configured in the Elasticsearch realm is automatically included and does not need to be specified as a commandline option.
  </definition>
  <definition term="--batch">
    Do not prompt for user input.
  </definition>
  <definition term="--contacts">
    Specifies that the metadata should include one or more `<ContactPerson>` elements. The user will be prompted to enter the details for each person.
  </definition>
  <definition term="-E <KeyValuePair>">
    Configures an Elasticsearch setting.
  </definition>
  <definition term="-h, --help">
    Returns all of the command parameters.
  </definition>
  <definition term="--locale <name>">
    Specifies the locale to use for metadata elements such as `<ServiceName>`. Defaults to the JVM’s default system locale.
  </definition>
  <definition term="--organisation-display-name <name">
    Specified the value of the `<OrganizationDisplayName>` element. Only valid if `--organisation-name` is also specified.
  </definition>
  <definition term="--organisation-name <name>">
    Specifies that an `<Organization>` element should be included in the metadata and provides the value for the `<OrganizationName>`. If this is specified, then `--organisation-url` must also be specified.
  </definition>
  <definition term="--organisation-url <url>">
    Specifies the value of the `<OrganizationURL>` element. This is required if `--organisation-name` is specified.
  </definition>
  <definition term="--out <file_path>">
    Specifies a path for the output files. Defaults to `saml-elasticsearch-metadata.xml`
  </definition>
  <definition term="--service-name <name>">
    Specifies the value for the `<ServiceName>` element in the metadata. Defaults to `elasticsearch`.
  </definition>
  <definition term="--signing-bundle <file_path>">
    Specifies the path to an existing key pair (in PKCS#12 format). The private key of that key pair will be used to sign the metadata file.
  </definition>
  <definition term="--signing-cert <file_path>">
    Specifies the path to an existing certificate (in PEM format) to be used for signing of the metadata file. You must also specify the `--signing-key` parameter. This parameter cannot be used with the `--signing-bundle` parameter.
  </definition>
  <definition term="--signing-key <file_path>">
    Specifies the path to an existing key (in PEM format) to be used for signing of the metadata file. You must also specify the `--signing-cert` parameter. This parameter cannot be used with the `--signing-bundle` parameter.
  </definition>
  <definition term="--signing-key-password <password>">
    Specifies the password for the signing key. It can be used with either the `--signing-key` or the `--signing-bundle` parameters.
  </definition>
  <definition term="--realm <name>">
    Specifies the name of the realm for which the metadata should be generated. This parameter is required if there is more than 1 `saml` realm in your Elasticsearch configuration.
  </definition>
  <definition term="-s, --silent">
    Shows minimal output.
  </definition>
  <definition term="-v, --verbose">
    Shows verbose output.
  </definition>
</definitions>


## Examples

The following command generates a default metadata file for the `saml1` realm:
```sh
bin/elasticsearch-saml-metadata --realm saml1
```

The file will be written to `saml-elasticsearch-metadata.xml`. You may be prompted to provide the "friendlyName" value for any attributes that are used by the realm.
The following command generates a metadata file for the `saml2` realm, with a `<ServiceName>` of `kibana-finance`, a locale of `en-GB` and includes `<ContactPerson>` elements and an `<Organization>` element:
```sh
bin/elasticsearch-saml-metadata --realm saml2 \
    --service-name kibana-finance \
    --locale en-GB \
    --contacts \
    --organisation-name "Mega Corp. Finance Team" \
    --organisation-url "<EXAMPLE_URL>/finance/"
```