﻿---
title: elasticsearch-croneval
description: Validates and evaluates a cron expression. This command enables you to verify that your cron expressions are valid for use with Elasticsearch and produce...
url: https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/elasticsearch-croneval
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# elasticsearch-croneval
Validates and evaluates a [cron expression](/docs/reference/elasticsearch/rest-apis/api-conventions#api-cron-expressions).

## Synopsis

```shell
bin/elasticsearch-croneval <expression>
[-c, --count <integer>] [-h, --help]
([-s, --silent] | [-v, --verbose])
```


## Description

This command enables you to verify that your cron expressions are valid for use with Elasticsearch and produce the expected results.
This command is provided in the `$ES_HOME/bin` directory.

## Parameters

<definitions>
  <definition term="-c, --count ">
    The number of future times this expression will be triggered. The default value is `10`.
  </definition>
  <definition term="-d, --detail">
    Shows detail for invalid cron expression. It will print the stacktrace if the expression is not valid.
  </definition>
  <definition term="-h, --help">
    Returns all of the command parameters.
  </definition>
  <definition term="-s, --silent">
    Shows minimal output.
  </definition>
  <definition term="-v, --verbose">
    Shows verbose output.
  </definition>
</definitions>


## Example

If the cron expression is valid, the following command displays the next 20 times that the schedule will be triggered:
```bash
bin/elasticsearch-croneval "0 0/1 * * * ?" -c 20
```