﻿---
title: elasticsearch-create-enrollment-token
description: The elasticsearch-create-enrollment-token command creates enrollment tokens for Elasticsearch nodes and Kibana instances. Use this command to create enrollment...
url: https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/create-enrollment-token
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# elasticsearch-create-enrollment-token
The `elasticsearch-create-enrollment-token` command creates enrollment tokens for Elasticsearch nodes and Kibana instances.

## Synopsis

```shell
bin/elasticsearch-create-enrollment-token
[-f, --force] [-h, --help] [-E <KeyValuePair>] [-s, --scope] [--url]
```


## Description

<note>
  `elasticsearch-create-enrollment-token` can only be used with Elasticsearch clusters that have been [auto-configured for security](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/installing-elasticsearch).
</note>

Use this command to create enrollment tokens, which you can use to enroll new Elasticsearch nodes to an existing cluster or configure Kibana instances to communicate with an existing Elasticsearch cluster that has security features enabled. The command generates (and subsequently removes) a temporary user in the [file realm](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/file-based) to run the request that creates enrollment tokens.
<important>
  You cannot use this tool if the file realm is disabled in your `elasticsearch.yml` file.
</important>

This command uses an HTTP connection to connect to the cluster and run the user management requests. The command automatically attempts to establish the connection over HTTPS by using the `xpack.security.http.ssl` settings in the `elasticsearch.yml` file. If you do not use the default configuration directory, ensure that the `ES_PATH_CONF` environment variable returns the correct path before you run the `elasticsearch-create-enrollment-token` command. You can override settings in your `elasticsearch.yml` file by using the `-E` command option. For more information about debugging connection failures, see [Setup-passwords command fails due to connection failure](https://www.elastic.co/docs/troubleshoot/elasticsearch/security/trb-security-setup).

## Parameters

<definitions>
  <definition term="-E <KeyValuePair>">
    Configures a standard Elasticsearch or X-Pack setting.
  </definition>
  <definition term="-f, --force">
    Forces the command to run against an unhealthy cluster.
  </definition>
  <definition term="-h, --help">
    Returns all of the command parameters.
  </definition>
  <definition term="-s, --scope">
    Specifies the scope of the generated token. Supported values are `node` and `kibana`.
  </definition>
  <definition term="--url">
    Specifies the base URL (hostname and port of the local node) that the tool uses to submit API requests to Elasticsearch. The default value is determined from the settings in your `elasticsearch.yml` file. If `xpack.security.http.ssl.enabled`  is set to `true`, you must specify an HTTPS URL.
  </definition>
</definitions>


## Examples

The following command creates an enrollment token for enrolling an Elasticsearch node into a cluster:
```shell
bin/elasticsearch-create-enrollment-token -s node
```

The following command creates an enrollment token for enrolling a Kibana instance into a cluster. The specified URL indicates where the elasticsearch-create-enrollment-token tool attempts to reach the local Elasticsearch node:
```shell
bin/elasticsearch-create-enrollment-token -s kibana --url "https://172.0.0.3:9200"
```